import time

import pygame
from pygame.locals import *

import gummworld2
from gummworld2 import State, Vec2d, data, subpixel, toolkit

import settings


class StatusMessage(object):
    
    def __init__(self, parent_view):
        self.parent = parent_view
        self.font = pygame.font.Font(data.filepath(
            'font', settings.statusmessage_font), 16)
        self.state = None
        self.duration = 0.
        self.speed = 1
    
    def new_message(self, text, duration=4., preempt=False):
        def rush_it(terminate):
            clock = State.clock
            callbacks = clock.update_callback,clock.frame_callback
            clock.update_callback,clock.frame_callback = self.update,self.draw
            blit = State.screen.blit
            back = State.screen.eraser
            w = State.screen.rect.w
            h = self.rect.h
            y = State.screen.rect.bottom - h
            blit_rect = Rect(0,y,w,h)
            save_speed = self.speed
            self.speed *= 3
            while self.state != terminate:
                blit(back, blit_rect, blit_rect)
                clock.tick()
                State.screen.flip()
            clock.update_callback,clock.frame_callback = callbacks
            self.speed = save_speed
        if self.state:
            if preempt:
                self.duration = 0.
                self.state = self.take_down
                rush_it(None)
            else:
                return
        self.state = self.put_up
        self.text = text
        self.duration = duration
        self.preempt = preempt
        self.image = self.font.render(text, True, Color('yellow'))
        self.rect = self.image.get_rect(
            centerx=self.parent.rect.centerx, y=self.parent.rect.bottom)
        if preempt:
            rush_it(self.take_down)
    
    def put_up(self):
        if self.rect.bottom > self.parent.rect.bottom:
            self.rect.bottom -= self.speed
        else:
            self.state = self.take_down
    
    def take_down(self):
        if self.duration <= 0.:
            if self.rect.top < self.parent.rect.bottom:
                self.rect.bottom += self.speed
            else:
                self.state = None
    
    def update(self, dt):
        if self.duration > 0.:
            self.duration -= dt
        if self.state:
            self.state()
    
    def draw(self, *args):
        if self.state:
            blit = self.parent.blit
            blit(self.image, self.rect)


if __name__ == '__main__':
    import time
    screen = State.screen = gummworld2.Screen((400,400))
    clock = State.clock = gummworld2.GameClock(30,120)
    msg = StatusMessage(screen)
    while 1:
        clock.tick()
        screen.clear()
        for e in pygame.event.get():
            if e.type == KEYDOWN:
                text = time.asctime()
                print 'new message:',text
                if e.key == K_x:
                    msg.new_message(text, preempt=True)
                else:
                    msg.new_message(text)
        if clock.update_ready: msg.update(clock.update_elapsed)
        if clock.frame_ready: msg.draw(clock.frame_elapsed)
        screen.flip()
