import os
import sys

import pygame
from pygame.locals import *

from gummworld2 import data

import keysyms, dictionary


## Fancy color cycling background (uses a lot of CPU when letters are idle)
background = True

## FPS cap: recommend 60 - 120
fps = 120

## Text reader speed: recommend 1-5
textreader_speed = 4

## default word list file
# Word lists have been filtered to remove words that are not completely
# lowercase alpha.
wordlists = [
    'normal.txt',   ## Moby 1.0 common.txt: 46883 words
    'hard.txt',     ## Moby 1.0 crossword.txt: 117969 words
    'insane.txt',   ## Moby 1.0 single.txt: 351076 words
]
wordlist = None     ## Valid values: None, or one of the filenames in wordlists

resolution = [800,600]      ## window size
fullscreen = False          ## fullscreen or no

# View subsurfaces dimensions
#                      x,y,w,h
title_dimensions =    (0.0,  0.0,  1.0,  0.1)
progress_dimensions = (0.0,  0.1,  1.0,  0.65)
letters_dimensions =  (0.0,  0.75, 1.0,  0.15)

# Add 'button' lookup for 'data/image/button'
data.set_subdir('button', os.path.join(data.subdirs['image'], 'button'))
# Add 'dictionary' lookup for 'data/text/mword'
data.set_subdir('dictionary', os.path.join(data.subdirs['text'], 'mword10'))

## Installed dictionary choices (stardict word translation). NOTE: The use of
## StarDict requires you to have the dictionary in the game resource directory.
## By default this is data/stardict.
##
## If you grabbed the StarDict-bundled version, then you are ready to use it.
## If you did not get the StarDict bundle, then you will need to get the
## dictionary files, install them in data/stardict, and configure the dictionary
## here. If you already have it installed for use with other programs, then you
## can just configure it.
##
## There are three configuration details: the data resource subdir; a dict
## entry; and stardict_name variable.
##
## The dict entry is in the form name:path+dictbase. The path is a concatenation
## of the data resource dir and the subdir typically created by unpacking
## the StarDict bundle. The dictbase is the dictionary filename without the
## file extension.
##
## For example, if you unpacked version 2.4.2 of the English StarDict to
## data/stardict, the resulting path+dictbase should be:
##
##  "data/stardict/stardict-dictd-web1913-2.4.2/dictd_www.dict.org_web1913"
##
## Finally, set the value of stardict_name to the dict key.
data.set_subdir('stardict', 'stardict')         # resource dir for stardicts
stardicts = {
    'english definition' :                      # key goes in stardict_name
        os.path.join(data.paths['stardict'],    # path to all stardicts
            'stardict-dictd-web1913-2.4.2',     # subdir for this stardict
            'dictd_www.dict.org_web1913',       # base name w/o file extension
        ),
}
stardict_name = 'english definition'

## Pecking order: If stardict_name is set and the StarDict directory is found,
## StarDict is used. Otherwise, if online_dictionary is set it is used. If
## neither is set then no lookup is done.
if stardict_name and os.access(data.paths['stardict'], os.F_OK):
    online_dictionary = ''
else:
    ## Set online_dictionary to "" to disable accessing the web site.
    online_dictionary = 'http://www.online-utility.org/english/dictionary.jsp'
    stardict_name = ''

title_font_name = 'VeraBd.ttf'
progress_font_name = 'Vera.ttf'
letters_font_name = 'VeraBd.ttf'
flipcard_font = 'Vera.ttf'
actionbutton_font = 'VeraBd.ttf'
statusmessage_font = 'VeraBd.ttf'
textreader_font = 'Vera.ttf'

credits_frequency = 11      ## float; Seconds between showing messages
credits_duration = 10.      ## float; Seconds to show each message

debug_subsurfs = False      ## Game.draw: draw rects around subsurfaces
fudge_max = False           ## Game.new_game: use crazy big letter combos
debug_flipcards = False     ## GameProgress: flipcard sizing messages


keys = keysyms.KeySyms([
    # name      [value1, ...]           description
    'letters',  list(dictionary.default_alphabet), 'Pick a letter',
    'enter',    [K_RETURN],             'Enter word',
    'clear',    [K_ESCAPE],             'Clear letter picks',
    'undo',     [K_BACKSPACE],          'Undo a picked letter',
    'shuffle',  [K_SPACE],              'Shuffler letters',
    'replay',   [K_UP,K_DOWN],          'Replay game',
    'sameword', [K_F1],                 'Replay same word',
])


## Command line args...

# Do not edit anything below this line unless your really want to hard-code the
# initial game config.

help_text = '''
usage: run_game.py [-normal|-hard|-insane] [-fullscreen] [-size WxH] [-speed n]
  [-background|-nobackground] [-help]

    -help                           this text
    -fullscreen                     use fullscreen display (default window)
    -background | -nobackground     run background (default -background)
    -normal | -hard | -insane       optional dictionaries (default -normal)
    -size WxH                       window/screen resolution (default 800x600)
    -speed n                        max FPS; recommend 60-120 (default 120)
    -word text min_len max_len      specify a word at startup

Examples:
  run_game.py -insane -word paeitsr 3 7  # 424 words =)
'''

# Leave the following defaults alone. Setting their values triggers command-line
# behaviors in the Game class.
startword = ''

if '-help' in sys.argv:
    print help_text
    sys.exit()
if '-fullscreen' in sys.argv:
    fullscreen = True
if '-background' in sys.argv:
    background = True
if '-nobackground' in sys.argv:
    background = False
if '-normal' in sys.argv:
    wordlist = 'normal.txt'
if '-hard' in sys.argv:
    wordlist = 'hard.txt'
if '-insane' in sys.argv:
    wordlist = 'insane.txt'
if '-size' in sys.argv:
    def _get_size():
        try:
            i = sys.argv.index('-size')
            i += 1
            size_str = sys.argv[i]
            size = [int(s) for s in size_str.split('x')]
            return size
        except:
            print 'error: bad -size usage'
            print help_text
            sys.exit()
    resolution = _get_size()
if '-speed' in sys.argv:
    def _get_speed():
        try:
            i = sys.argv.index('-speed')
            i += 1
            return int(sys.argv[i])
        except:
            print 'error: bad -speed usage'
            print help_text
            sys.exit()
    fps = _get_speed()
if '-word' in sys.argv:
    def _get_startword():
        try:
            i = sys.argv.index('-word')
            i += 1
            word,min_,max_ = sys.argv[i:i+3]
            return word,int(min_),int(max_)
        except:
            print 'error: bad -word usage'
            print help_text
            sys.exit()
    startword,min_len,max_len =_get_startword()
if '-debug' in sys.argv:
    fudge_max = True
