import pygame
from pygame.locals import *

import gummworld2
from gummworld2 import Engine
from gummworld2 import context

import settings, game


class Main(Engine):
    
    def __init__(self):
        display_flags = 0
        if settings.fullscreen: display_flags |= FULLSCREEN
        Engine.__init__(self,
            resolution=settings.resolution,
            display_flags=display_flags,
            frame_speed=90,
        )
    
    def enter(self):
        context.push(game.Game())
    
    def update(self, dt):
        context.pop()


def main():
    gummworld2.run(Main())
