import pygame
from pygame.locals import *

from gummworld2 import State, View
from gummworld2 import data

import settings


class GameTitle(View):
    
    def __init__(self, text='Vocab Extreme'):
        sw,sh = State.screen.size
        x,y,w,h = settings.title_dimensions
        View.__init__(self, subsurface_rect=Rect(x*sw, y*sh, w*sw, h*sh))
        
        self.value = text
        
        font_size = 35
        while 1:
            font_name = data.filepath('font',settings.title_font_name)
            font = pygame.font.Font(font_name, font_size)
            textw,texth = font.size(self.value)
            if textw < self.rect.w*.8 and texth < self.rect.h*.8:
                break
            font_size -= 1
        self.image = font.render(self.value, True, Color('white'))
    
    def update(self, dt):
        pass
    
    def draw(self, dt):
        if settings.debug_subsurfs:
            pygame.draw.rect(self.surface, Color('red'), self.rect, 1)
        rect = self.image.get_rect(center=self.rect.center)
        self.blit(self.image, rect)
