import pygame
from pygame.locals import *

from gummworld2 import State, View, Vec2d
from gummworld2 import data

import settings, flipcard


class GameProgress(View):
    
    def __init__(self, combos, right_edge):
        sw,sh = State.screen.size
        x,y,w,h = settings.progress_dimensions
        View.__init__(self, subsurface_rect=Rect(x*sw, y*sh, right_edge-x*sw, h*sh))
        
        self.combos = combos
        self.flipcards = []
        self.debug_rects = []
        self.make_flipcards()
        
        State.flipcards = dict([(card.text,card) for card in self.flipcards])
    
    def make_flipcards(self):
        def cmp_len(a,b):
            return cmp(len(a), len(b))
        debug = settings.debug_flipcards
        self.combos = sorted(self.combos, cmp_len)
        length = len(self.combos)
        if __debug__: print '%s: %d word combos' % (self.__class__.__name__, length)
        size,rowsep,colsep = self.size_me()
        max_len = 0
        offx,offy = colsep,colsep
        if debug: print '++ Making flipcards...'
        for n,text in enumerate(self.combos):
            card = flipcard.FlipCard(text, size, rowsep, colsep, self)
            rect = card.rect
            rect.topleft = offx,offy
            if rect.bottom > self.rect.bottom:
                offy = colsep
                offx += colsep + max_len
                max_len = 0
                rect.topleft = offx,offy
                if debug: print '++ new col',n,offx
            if rect.w > max_len: max_len = rect.w
            if debug: print '++ flipcard rect',n,card.rect
            self.flipcards.append(card)
            offy += size.y + rowsep
            if debug: print '++ bottomleft',n,(offx,offy)
    
    def size_me(self):
        debug = settings.debug_flipcards
        if debug: print '++ sizing flipcards...'
        action_button = pygame.image.load(data.filepath('button', 'action.png'))
        screen = Vec2d(self.rect.size)
        screen.x -= action_button.get_size()[0] + 10
        if debug: print '++ screen_size',screen
        choices = (
            # size, rowsep, colsep
            (Vec2d(24,24), 6, 20),
            (Vec2d(22,22), 5, 18),
            (Vec2d(20,20), 5, 16),
            (Vec2d(18,18), 4, 14),
            (Vec2d(16,16), 4, 12),
            (Vec2d(12,12), 3, 5),
            (Vec2d(10,10), 1, 3),
            (Vec2d(9,9), 1, 2),
        )
        for choice in choices:
            if debug: print '++ choice',choice
            self._X1 = screen.x
            self._Y1 = screen.y
            del self.debug_rects[:]
            size,rowsep,colsep = choice
            offx,offy = colsep,colsep
            max_len = 0
            for n,word in enumerate(self.combos):
                if offy+size.y > screen.y:
                    offx += colsep + max_len*(size.x+rowsep)
                    self._Y1 = min(offy+rowsep+size.y, screen.y)
                    offy = colsep
                    max_len = 0
                    if debug: print '++ new col',n,offx
                    if offx > screen.x:
                        if debug: print '++ too big, preempt',offx,screen.x
                        break
                if debug:
                    self.debug_rects.append(Rect(
                        offx, offy, len(word)*(size.x+rowsep), size.y))
                max_len = max(len(word),max_len)
                offy += size.y + rowsep
                if debug: print '++ bottomleft',n,(offx,offy)
            offx += colsep + max_len*(size.x+rowsep)-rowsep
            self._X2 = offx
            if debug: print '++ bottomright',n,(offx,offy)
            if offx <= screen.x:
                if debug: print '++ fits',offx,screen.x
                break
            else:
                if debug: print '++ too big, last col',offx,screen.x
        return choice
    
    def update(self, dt):
        pass
    
    def draw(self, dt):
        blit = self.blit
        if settings.debug_subsurfs:
            pygame.draw.rect(self.surface, Color('green'), self.rect, 1)
        for card in self.flipcards:
            blit(card.image, card.rect)
        
        if settings.debug_flipcards:
            surf = self.surface
            x,y = self.rect.bottomright
            pygame.draw.line(surf, Color('red'), (self._X1,0), (self._X1,y))
            pygame.draw.line(surf, Color('yellow'), (self._X2,0), (self._X2,y))
            pygame.draw.line(surf, Color('yellow'), (0,self._Y1), (x,self._Y1))
            color = Color('darkgrey')
            for r in self.debug_rects:
                pygame.draw.rect(surf, color, r, 1)
