import pygame
from pygame.locals import *

from gummworld2 import Vec2d
from gummworld2 import data

import settings

class FlipCard(object):
    
    def __init__(self, text, size, rowsep, colsep, parent_view):
        self.text = text
        self.parent = parent_view
        self.size = Vec2d(size)
        self.rowsep = rowsep
        self.colsep = colsep
        
        self.blanks = {}
        self.bg_image = None
        self.font = None
        self.make_blank()
        
        self.image = self.blanks[len(self.text)].copy()
        self.rect = self.image.get_rect()
        
        self.peek_idx = 0
        self.flipped = False
    
    def make_blank(self):
        size = self.size
        rowsep = self.rowsep
        colsep = self.colsep
        
        load = pygame.image.load
        filepath = data.filepath
        self.bg_image = pygame.Surface(size)
        self.bg_image.fill(Color('#804DD2'))
        
        font_size = 22
        font_file = data.filepath('font', settings.flipcard_font)
        height = self.bg_image.get_size()[1]
        while 1:
            self.font = pygame.font.Font(font_file, font_size)
            if self.font.size('W')[1] <= height:
                break
            font_size -= 1
        
        length = len(self.text)
        if length not in self.blanks:
#            size = Vec2d(self.bg_image.get_size())
            size.x = (size.x + rowsep) * length
            blank_image = pygame.Surface(size)
            blank_image.set_colorkey(Color('black'))
            for x in range(0, size.x, size.x/length):
                rect = self.bg_image.get_rect(topleft=(x,0))
                blank_image.fill(Color(1,1,1), rect)
                pygame.draw.rect(blank_image, Color('darkviolet'), rect, 1)
            self.blanks[length] = blank_image
    
    def click(self, mouse_pos):
        pos = Vec2d(mouse_pos) - self.parent.abs_offset
        return self.rect.collidepoint(pos)
    
    def peek(self):
        if self.peek_idx < len(self.text):
            self.render(self.peek_idx, Color(1,1,1))
            self.peek_idx += 1
    
    def flip(self):
        self.render(range(len(self.text)), color=Color(1,1,1))
    
    def render(self, val=None, color=Color('white')):
        """Render one or more characters on my surface.
        
        val can be an int, a str, or a sequence of int.
        """
        if self.flipped:
            return
        
        def draw_char(c, i):
            tex_image = self.font.render(c, True, color) 
            bg_rect = self.bg_image.get_rect()
            image_rect = self.image.get_rect()
            width = bg_rect.w + self.rowsep
            bg_rect.x = width * i
            bg_rect.centery = image_rect.centery
            tex_rect = tex_image.get_rect(center=bg_rect.center)
            self.image.blit(self.bg_image, bg_rect)
            self.image.blit(tex_image, tex_rect)
        
        if val is None:
            val = self.text
        if isinstance(val, int):
            # Single character by index
            draw_char(self.text[val], val)
            if val == len(self.text)-1:
                val = self.text
        elif isinstance(val, str):
            # One or more characters
            for i,c in enumerate(val):
                if c in val: draw_char(c, i)
        else:
            # One or more indices
            for i in val:
                c = self.text[i]
                draw_char(c, i)
            if i == len(self.text)-1:
                val = self.text
        
        if val == self.text:
            self.flipped = True
