import os
import random

from gummworld2 import data

import settings


class Words(object):
    
    def __init__(self, file_name, depth=3, picks=(4,5,6,7)):
        self.file_name = file_name
        self.depth = depth
        self.picks = picks
        
        self.file = open(file_name, 'rb')
        self.idx = {}
        self.pick_sets = {}
        self.current = []
        
        self.count = 0
        self.load()
    
    def load(self):
        count = 0
        
        file = self.file
        idx = self.idx
        pick_sets = self.pick_sets
        current = self.current
        depth = self.depth
        picks = self.picks
        
        idx.clear()
        pick_sets.clear()
        for i in picks: pick_sets[i] = []
        current[:] = [''] * self.depth
        file.seek(0)
        
        pos = file.tell()
        while 1:
            line = file.readline()
            if not len(line):
                break
            count += 1
            line = line.rstrip()
            length = len(line)
            if length in picks:
                pick_sets[length].append(pos)
            for n in range(self.depth):
                if length > n:
                    key = line[:n+1]
                    if key > current[n]:
                        current[n] = key
                        idx[key] = pos
            pos = file.tell()
            self.count = count
        if __debug__:
            print '%s: loaded %d words, built %d indices' % (
                self.__class__.__name__,count,len(idx))
    
    def random_pick(self, pick):
        pick_set = self.pick_sets[pick]
        pos = random.choice(pick_set)
        self.file.seek(pos)
        line = self.file.readline().rstrip()
        return line
    
    def __contains__(self, item):
        idx = self.idx
        file = self.file
        key = item[:self.depth]
        if key in idx:
            file.seek(idx[key])
            while 1:
                word = file.readline()
                if not len(word):
                    # EOF
                    return False
                word = word.rstrip()
                if not word.startswith(key):
                    # Potential matches exhausted
                    return False
                if word == item:
                    # Match
                    return True
        # should never fall through, but just for clarity...
        return False

default_alphabet = 'abcdefghijklmnopqrstuvwxyz'


def words_gen(minimum, maximum, seq, words):
    """Return a list of words that match any permutations of the letters in seq.
    
    minimum, maximum -> the min and max lengths of words to generate.
    seq -> the list of characters to permutate.
    words -> the Words object to search.
    """
    
    def remove(miss, src):
        "Returns the list of items in src not present in miss"
        new = list(src)
        new.remove(miss)
        return new
    
    def permutation_gen(n, l):
        "Generates all the permutations of n items of the l list"
        for i in l:
            if n<=1: yield [i]
            r = [i]
            for j in permutation_gen(n-1,remove(i,l)):  yield r+j
    
    results = set()
    maximum = min(len(seq)+1, maximum+1)
    for length in range(minimum, maximum):
        for item in permutation_gen(length, seq):
            word = ''.join(item)
            if (minimum <= len(word) < maximum) and word in words:
                results.add(word)
    return sorted(results)


def min_letters(word_list):
    """Return minimum set of letters required to make each word in list."""
    count = {}
    for word in word_list:
        for c in word:
            count[c] = max(count.get(c,0), word.count(c))
    result = ''
    for c in count:
        result += c*count[c]
    return result


def random_words(seed_word, min_len, max_len, words):
    """Return the list of words that can be made from the letters in seed word."""
    results = set()
    while 1:
        for match in words_gen(min_len, max_len, seed_word, words):
            results.add(match)
        return min_letters(results),sorted(results)


if __name__ == '__main__':
    default_words = Words('../data/text/mword10/normal.txt')
    assert 'aa' in default_words
    
    print 'All combos of letters "good":'
    src = 'good'
    combos = words_gen(3,7,src,default_words)
    print '\n'.join(combos)
    
    print 'Three random picks:'
    print default_words.random_pick(5)
    print default_words.random_pick(6)
    print default_words.random_pick(7)
    
    seed_words = [default_words.random_pick(n) for n in 5,6,7]
    seed_words.extend(['analogs', 'greatly', 'redias'])
    for seed_word in seed_words:
        min_len = 4
        max_len = 7
        src,combos = random_words(seed_word, min_len, max_len, default_words)
        while len(combos) > 20:
            if min_len == max_len:
                break
            save = combos
            min_len += 1
            print seed_word,'length > 20: rerolling with',min_len
            src,combos = random_words(seed_word, min_len, max_len, default_words)
            if len(combos) == 0:
                combos = save
                break
        print '%d combos of letters "%s"' % (len(combos),seed_word)
        print '\n'.join(combos)
    
    print '\nDone.'
