import random

import pygame
from pygame.locals import *

from gummworld2 import State

import  gradients


class BackgroundDecorator(object):
    
    def __init__(self):
        self.rects = []
        self.startcolors = []
        self.endcolors = []
        self.fillcolor = None
        
        self.prev_rects = []
        self.prev_startcolors = []
        self.prev_endcolors = []
        self.prev_fillcolor = None
        
        self.rect_idx = 0
        
        self.locolor_range = [144,166]
        self.hicolor_range = [182,214]
        
        self.new_rects()
        self.new_colors()
        self.circle_stamp = State.screen.surface.copy()
        self.circle_stamp.fill((0,0,0))
        
        self.fade_rate = .1
        self.fade_elapsed = self.fade_rate
        self.flip_rate = 60.
        self.flip_elapsed = self.flip_rate
        
        self.update(0)
        for idx in range(len(self.rects)):
            self.render(idx)
    
    def new_rects(self):
        rr = random.randrange
        screen_rect = State.screen.rect
        
        del self.rects[:]
        
        y = 0
        while y < screen_rect.bottom:
            height = rr(100,200)
            if y + height > screen_rect.bottom:
                height = screen_rect.bottom - y
            subrect = Rect(0,y,screen_rect.right,height)
            self.rects.append(subrect)
            y += height
        
    def new_colors(self):
        rr = random.randrange
        
        self.elapsed = 0.
        self.prev_startcolors[:] = self.startcolors
        self.prev_endcolors[:] = self.endcolors
        self.prev_fillcolor = self.fillcolor
        del self.startcolors[:]
        del self.endcolors[:]
        
        domcolor = rr(3)
        rgb = [rr(32),rr(32,64),rr(63,96)]
        random.shuffle(rgb)
        endcolor = list(rgb)
        endcolor[domcolor] = rr(*self.locolor_range)
        
        for i in range(len(self.rects)):
            startcolor = list(endcolor)
            if self.locolor_range[0] <= endcolor[domcolor] < self.locolor_range[1]:
                endcolor[domcolor] = rr(*self.hicolor_range)
            else:
                endcolor[domcolor] = rr(*self.locolor_range)
            self.startcolors.append(Color(*startcolor))
            self.endcolors.append(Color(*endcolor))
        
        self.fillcolor = vec_round([abs(c*1/10) for c in endcolor])
    
    def update_all(self):
        self.new_colors()
        for i,r in enumerate(self.rects):
            self.render(i)
    
    def update(self, dt):
        self.flip_elapsed += dt
        if self.flip_elapsed >= self.flip_rate:
            self.flip_elapsed -= self.flip_rate
            self.new_colors()
        self.fade_elapsed += dt
        if self.fade_elapsed >= self.fade_rate:
            self.fade_elapsed -= self.fade_rate
            self.rect_idx += 1
            if self.rect_idx >= len(self.rects):
                self.rect_idx = 0
            self.render(self.rect_idx)
    
    def render(self, idx, screen=None):
        if screen is None:
            screen = State.screen.eraser
        screen_rect = screen.get_rect()
        subrect = self.rects[idx]
        startcolor,endcolor,fillcolor = self.interp_colors(idx)
        subsurf = screen.subsurface(subrect)
        startpoint = 0,0
        endpoint = 0, subsurf.get_size()[1]
        gradients.draw_gradient(
            subsurf, startpoint, endpoint, startcolor, endcolor)
        pygame.draw.circle(
            screen, fillcolor, screen_rect.center, screen_rect.w*7/18)
    
    def interp_colors(self, i):
        interp = self.flip_elapsed / self.flip_rate
        if interp > 1.0: interp = 1.0
        #print interp
        start = [n*interp for n in vec_sub(self.startcolors[i],self.prev_startcolors[i])]
        end = [n*interp for n in vec_sub(self.endcolors[i],self.prev_endcolors[i])]
        fill = [n*interp for n in vec_sub(self.fillcolor,self.prev_fillcolor)]
        return (
            vec_round(vec_add(self.prev_startcolors[i], start)),
            vec_round(vec_add(self.prev_endcolors[i], end)),
            vec_round(vec_add(self.prev_fillcolor, fill)),
        )


def vec_sub(a, b):
    return [a[i] - b[i] for i in range(len(a))]

def vec_add(a, b):
    return [a[i] + b[i] for i in range(len(a))]

def vec_round(a):
    return [int(round(n)) for n in a]
