import pygame
from pygame.locals import *

from gummworld2 import Vec2d
from gummworld2 import data

import settings


class ActionButton(object):
    
    font = None
    
    def __init__(self, text, callback, parent_view):
        self.text = text
        self.callback = callback
        self.parent = parent_view
        
        load = pygame.image.load
        filepath = data.filepath
        self.button_image = load(filepath('button', 'action.png'))
        self.button_rect = self.button_image.get_rect()
        
        if not self.font:
            font_size = 22
            font_file = data.filepath('font', settings.actionbutton_font)
            height = self.button_image.get_size()[1]
            while 1:
                self.font = pygame.font.Font(font_file, font_size)
                if self.font.size('W')[1]+2 <= height:
                    break
                font_size -= 1
        
        self.tex_image = self.font.render(self.text, True, Color(1,1,1))
        self.tex_rect = self.tex_image.get_rect(center=self.button_rect.center)
    
    def click(self, pos):
        pos = Vec2d(pos) - self.parent.abs_offset
        if self.button_rect.collidepoint(pos):
            self.callback()
    
    def draw(self):
        self.parent.blit(self.button_image, self.button_rect)
        if self.tex_rect.center != self.button_rect.center:
            self.tex_rect.center = self.button_rect.center
        self.parent.blit(self.tex_image, self.tex_rect)
