#--------------------------------------------------------------------------------
#
#   SimChip2 - Web site interfacing
#
#--------------------------------------------------------------------------------

import os, sys, time
from httplib import HTTPConnection
from urllib import urlencode
from threading import Thread

test_server = ("127.0.0.1", 8000)
live_server = test_server

server_str = os.environ.get("SIMCHIP_STATS_SERVER")
if server_str:
	server = server_str.split(":")
elif os.environ.get("SIMCHIP_STATS_TEST"):
	server = test_server
else:
	server = live_server

print "www: server =", server ###
		
submit_url = "/simchip/submit_solution/"
retrieve_url = "/simchip/retrieve_stats/"

debug = "-dwww" in sys.argv
if debug:
	print "www: Debugging enabled"

def submit(level_key, solution_text, stats):
	#<<<
	if 0:
		time.sleep(1)
		print "Bing!"
		time.sleep(1)
		print "Bing! Bing!"
	#>>>
	if debug:
		print "www.submit:", level_key, solution_text[:30] + "..."
	params = dict(level_key = level_key, solution = solution_text)
	params.update(stats)
	data = urlencode(params)
	if debug:
		print "www.submit: creating HTTPConnection" ###
	conn = HTTPConnection(*server)
	if debug:
		print "www.submit: sending request" ###
	conn.request("POST", submit_url, data)
	if debug:
		print "www.submit: reading response" ###
	resp = conn.getresponse()
	if debug:
		print "www.submit: status =", resp.status, resp.reason
	if resp.status == 500:
		if debug:
			dump_response(resp)
		return
	if debug:
		print resp.read()

def retrieve(level_key = None):
	if debug:
		print "www.retrieve:", level_key
	params = dict()
	if level_key:
		params["level_key"] = level_key
	conn = HTTPConnection(*server)
	url = "%s?%s" % (retrieve_url, urlencode(params))
	conn.request("GET", url)
	resp = conn.getresponse()
	if debug:
		print "www.retrieve: status =", resp.status, resp.reason
	if resp.status in (404, 500):
		if debug:
			dump_response(resp)
		return
	data = resp.read()
	if debug:
		print data
	return data

def dump_response(resp):
	path = os.path.abspath("response.html")
	f = open(path, "w")
	f.write(resp.read())
	f.close()
	print "Reponse saved in", path

def bg_submit(*args, **kwds):
	thread = Thread(target = submit, args = args, kwargs = kwds)
	thread.setDaemon(True)
	thread.start()
	#<<<
	if 0:
		print "www: Main thread sleeping for 10" ###
		time.sleep(10)
		print "www: Main thread sleep finished" ###
	#>>>

def submit_results(chip, results):
	if debug: ###
		bg_submit(chip.level_key, chip.structure.to_string(), results.__dict__)
		#submit(chip.level_key, chip.structure.to_string(), results.__dict__)

if __name__ == "__main__":
	debug = True
	import sys, time
	#from AppKit import NSApplication
	from GUI import Application
	cmd = sys.argv[1]
	if cmd == "-s":
		bg_submit("TESTING2", "MyHovercraftExplodesWithDelight",
			dict(supply_current = 1.7, propagation_delay = 4.2, silicon_area = 88))
		#time.sleep(10)
		#app = NSApplication.sharedApplication()
		#print "Running NSApplication"
		app = Application()
		print "Running GUI.Application"
		app.run()
	elif cmd == "-r":
		retrieve()
