#--------------------------------------------------------------
#
#   SimChip2 - Waveform window
#
#--------------------------------------------------------------

from GUI import Window, Row
from waveform_view import WaveformView
from waveform_controls import WaveformControls
from controls import WorkbenchButton, RunTestButton

class WaveformWindow(Window):

	keeps_document_open = False

	game = property(lambda self: self.document)

	def __init__(self, game):
		Window.__init__(self, document = game, auto_position = False,
			position = (200, 150), size = (800, 600))
		wave_view = WaveformView(game)
		wave_controls = WaveformControls(game)
		buttons = Row([WorkbenchButton(game), RunTestButton(game)],
			padding = (5, 5))
		self.waveform_view = wave_view
		self.waveform_controls = wave_controls
		self.place(wave_controls, left = self, bottom = self, anchor = 'lb')
		self.place(buttons, right = self, bottom = self, anchor = 'rb')
		self.place(wave_view, left = self, top = self, right = self,
			bottom = wave_controls, anchor = 'ltrb')
		game.add_view(self)
		self.current_level_changed()
	
	def close_cmd(self):
		self.hide()

	def update_title(self):
		game = self.game
		level = game.current_level
		self.title = "Waveforms - %d - %s" % (level.index + 1, level.title)

	def current_level_changed(self, *args):
		self.update_title()
