#--------------------------------------------------------------
#
#   SimChip2 - Waveform controls
#
#--------------------------------------------------------------

from GUI import Row, Button
from simulation import AUTO_OFF, AUTO_PAUSE, AUTO_RUN

class WaveformControls(Row):

	def __init__(self, game):
		self.start_button = Button("Start", action = 'start')
		self.stop_button = Button("Stop", action = 'stop')
		self.pause_button = Button("Pause", action = 'pause')
		Row.__init__(self, [self.stop_button, self.start_button, self.pause_button],
			padding = (5, 5))
		self.game = game
		game.add_view(self)
		self.update_buttons()
	
	def current_level_changed(self, *args):
		self.update_buttons()
	
	def current_setup_changed(self, *args):
		self.update_buttons()
	
	def auto_mode_changed(self, *args):
		self.update_buttons()
	
	def update_buttons(self):
		chip = self.game.current_chip
		mode = chip.state.auto_mode
		self.start_button.enabled = mode <> AUTO_RUN
		self.stop_button.enabled = mode <> AUTO_OFF
		self.pause_button.enabled = mode == AUTO_RUN \
			and not chip.test_setup_selected()
	
	def start(self):
		self.set_mode(AUTO_RUN)
	
	def stop(self):
		self.set_mode(AUTO_OFF)
	
	def pause(self):
		self.set_mode(AUTO_PAUSE)
	
	def set_mode(self, mode):
		self.game.current_chip.set_auto_mode(mode)
