#--------------------------------------------------------------
#
#   SimChip2 - Tools
#
#--------------------------------------------------------------

from resources import get_image, get_cursor

def get_tool(name, **kwds):
	return get_image("tools/" + name, **kwds)

SELECT = 'select'
CONFIGURE = 'configure'
SIL_N = 'n'
SIL_P = 'p'
SIL_NPLUS = 'n+'
SIL_PPLUS = 'p+'
METAL = 'metal'
VIA = 'via'
QGOGGLES = 'qg'

palette_images = {
	SELECT: get_tool('tool-marquee.png'),
	CONFIGURE: get_tool('tool-screwdriver.png'),
	SIL_N: get_tool('tool-n.png'),
	SIL_P: get_tool('tool-p.png'),
	SIL_NPLUS: get_tool('tool-n+.png'),
	SIL_PPLUS: get_tool('tool-p+.png'),
	METAL: get_tool('tool-metal.png'),
	VIA: get_tool('tool-via.png'),
	QGOGGLES: get_tool('tool-qgoggles.png'),
}

cursors = {
	SELECT: None,
	CONFIGURE: get_cursor('cursor-screwdriver.png', hotspot = (2, 2)),
	SIL_N: get_cursor('cursor-n.png', hotspot = (5, 5)),
	SIL_P: get_cursor('cursor-p.png', hotspot = (5, 5)),
	SIL_NPLUS: get_cursor('cursor-n+.png', hotspot = (5, 5)),
	SIL_PPLUS: get_cursor('cursor-p+.png', hotspot = (5, 5)),
	METAL: get_cursor('cursor-metal.png', hotspot = (5, 5)),
	VIA: get_cursor('cursor-via.png'),
}
