#--------------------------------------------------------------
#
#   SimChip2 - Tool palette
#
#--------------------------------------------------------------

from GUI.Geometry import rect_with_center, rect_center
from GUI import PaletteView, rgb
import tools

palette_cell_size = (32, 32)
palette_items = [
	tools.SELECT,
	tools.SIL_N,
	tools.SIL_P,
	tools.SIL_NPLUS,
	tools.SIL_PPLUS,
	tools.METAL,
	tools.VIA,
	tools.CONFIGURE,
	tools.QGOGGLES,
]

class ToolPalette(PaletteView):

	def __init__(self):
		n = len(tools.palette_images)
		PaletteView.__init__(self, num_items = n, items_per_row = n,
			cell_size = palette_cell_size,
			highlight_color = rgb(0, 0.5, 1.0),
			border = True)

	def draw_item(self, canvas, i, rect):
		img = tools.palette_images[palette_items[i]]
		src = img.bounds
		dst = rect_with_center(src, rect_center(rect))
		img.draw(canvas, src, dst)

	def click_item(self, i, event):
		tool = palette_items[i]
		#if tool == tools.QGOGGLES:
		#	self.window.toggle_show_voltages()
		#else:
		self.window.select_tool(tool)

	def item_is_selected(self, i):
		tool = palette_items[i]
		#if tool == tools.QGOGGLES:
		#	return self.window.show_voltages
		#else:
		return self.window.selected_tool == tool

