#--------------------------------------------------------------
#
#   SimChip2 - Out-of-box experience
#
#--------------------------------------------------------------

from GUI import ModalDialog, Column, Button, Label, application

class OOBDialog(ModalDialog):

	def __init__(self):
		ModalDialog.__init__(self, title = "Welcome to SimChip")
		new_button = Button("Start New Game", action = 'new')
		open_button = Button("Load Game...", action = 'load')
		quit_button = Button("Quit", action = 'quit')
		contents = Column([
			Label("If you haven't played before, click here:"),
			new_button,
			Label("\nTo restore a previous game, click here:"),
			open_button,
			Label(""),
			quit_button,
		], equalize = 'w')
		self.place(contents, left = 20, top = 20)
		self.shrink_wrap()
	
	def new(self):
		application().new_cmd()
		self.dismiss()
	
	def load(self):
		application().open_cmd()
		self.dismiss()
	
	def quit(self):
		application().quit_cmd()
		self.dismiss()
