#--------------------------------------------------------------
#
#   SimChip2 - I/O device view
#
#--------------------------------------------------------------

from __future__ import division
from GUI import View, rgb
from GUI.Geometry import pt_in_rect
from resources import get_image
from dymo import draw_dymo_text
from config_editing import edit_pin_config
import tools

class Device(object):

	def click(self, chip, pin_index, setup):
		pass

	def draw(self, canv, chip, pin_index, setup, rect):
		img =	self.images[bool(setup.state)]
		img.draw(canv, img.bounds, rect)
	
class Switch(Device):

	images = [
		get_image("switch-down.png"),
		get_image("switch-up.png")
	]

	def click(self, chip, pin_index, setup):
		chip.change_input_state(pin_index, setup, not setup.state)


class LED(Device):

	images = [
		get_image("led-off.png"),
		get_image("led-on.png")
	]

	def draw(self, canv, chip, pin_index, setup, rect):
		state = chip.logic_level_of_pin(pin_index)
		img =	self.images[state]
		img.draw(canv, img.bounds, rect)


class Terminal(Device):

	images = [
		get_image("terminal-black.png"),
		get_image("terminal-red.png")
	]


class NoDevice(Device):

	image = get_image("no_device.png")
	images = [image, image]


devices = {
	'switch': Switch(),
	'led': LED(),
	'terminal': Terminal(),
	None: NoDevice(),
}

#--------------------------------------------------------------

class DeviceView(View):

	device_width = 50
	label_area_width = 70
	slot_width = device_width + label_area_width
	slot_height = 50
	bg_color = rgb(0, 115/255, 152/255)

	def __init__(self, side):
		View.__init__(self, width = self.slot_width)
		self.side = side
	
	chip = property(lambda self: self.window.chip)
	
	num_slots = property(lambda self: self.chip.num_pins_on_side(self.side))

	def draw(self, c, ur):
		#print "DeviceView.draw: side", self.side, "in", ur ###
		#c.erase_rect(ur)
		c.fillcolor = self.bg_color
		c.fill_rect(ur)
		chip = self.chip
		s = self.side
		if chip:
			#print "DeviceView.draw: chip =", chip ###
			for i in xrange(self.num_slots):
				p = chip.index_of_pin_on_side(s, i)
				setup = chip.current_setup[p]
				#print "DeviceView.draw:", setup.device, "in slot", i ###
				device = devices.get(setup.device)
				if device:
					r = self.device_rect_for_slot(i)
					device.draw(c, chip, p, setup, r)
				name = setup.name
				if name:
					pos = self.label_position_for_slot(i)
					draw_dymo_text(c, name, pos)

	def mouse_down(self, e):
		pos = e.position
		s = self.side
		for i in xrange(self.num_slots):
			if pt_in_rect(pos, self.device_rect_for_slot(i)):
				chip = self.chip
				p = chip.index_of_pin_on_side(s, i)
				if self.window.selected_tool == tools.CONFIGURE:
					edit_pin_config(chip, p)
				else:
					setup = chip.current_setup[p]
					device = devices.get(setup.device)
					if device:
						device.click(chip, p, setup)

	def device_rect_for_slot(self, i):
		w = self.device_width
		h = self.slot_height
		t = h * i
		return (0, t, w, t + h)

	def label_position_for_slot(self, i):
		x = self.device_width + self.label_area_width // 2
		h = self.slot_height
		y = h * i + h // 2
		return (x, y)

	def tool_changed(self):
		tool = self.window.selected_tool
		if tool == tools.CONFIGURE:
			self.cursor = tools.cursors[tool]
		else:
			self.cursor = None

