#--------------------------------------------------------------
#
#   SimChip2 - Time measurement
#
#--------------------------------------------------------------

from sys import platform

if platform.startswith("win"):

	from win32process import GetCurrentProcess, GetProcessTimes
	this = GetCurrentProcess()
	
	def cpu_time():
		s = GetProcessTimes(this)
		return (s['UserTime'] + s['KernelTime']) / 1e7

else:

	from time import clock as cpu_time
