#--------------------------------------------------------------
#
#   SimChip2 - Testing
#
#--------------------------------------------------------------

from numpy import zeros, int32
from GUI import Window, Label, Button, Row, Column, Grid
from simulation import Vcc

Vt = 0.5 * Vcc

#--------------------------------------------------------------

class TestResultsWindow(Window):

	keeps_document_open = False

	game = property(lambda self: self.document)

	def __init__(self, game):
		Window.__init__(self, document = game)
		self.heading = Label(width = 300)
		self.correctness = Label("999% (100% required)")
		self.accuracy = Label("999%")
		self.passflag = Label("XXXXXX")
		results = Grid([
			[Label("Correctness"), self.correctness],
			[Label("Accuracy"), self.accuracy],
			[self.passflag],
		])
		self.next_button = Button("Next Level", action = 'next_level')
		buttons = Row([None, self.next_button], expand = 0)
		heading_and_results = Column([self.heading, results], align = 'l')
		contents = Column([heading_and_results, buttons], align = 'r', padding = (20, 20))
		self.add(contents)
		self.shrink_wrap()
		game.add_view(self)
		self.current_level_changed()
	
	def close_cmd(self):
		self.hide()
	
	def current_level_changed(self, *args):
		self.update_title()
		self.test_results_changed()
	
	def test_results_changed(self, *args):
		#print "TestResultsWindow.test_results_changed" ###
		self.update_results()
		self.update_buttons()
	
	def update_title(self):
		level = self.game.current_level
		self.title = "Test Results - Level %s" % (level.index + 1)
	
	def update_results(self):
		level = self.game.current_level
		self.heading.text = level.title
		results = level.test_results
		if results:
			c = results.correctness
			ct = "%d%%" % c
			at = "%d%%" % results.accuracy
			passed = results.passed()
			if not passed:
				ct += " (100% required)"
			pf =  "PASSED" if passed else "FAILED"
		else:
			ct = at = pf = ""
		self.correctness.text = ct
		self.accuracy.text = at
		self.passflag.text = pf

	def update_buttons(self):
		self.next_button.enabled = self.game.next_level_is_unlocked()
	
	def next_level(self):
		self.game.select_next_level()
		self.close_cmd()

#--------------------------------------------------------------

class TestResults(object):
	#  correctness   int   percentage
	#  accuracy      int   percentage
	
	def passed(self):
		return self.correctness >= 100

def check_test_results(level):
	setup = level.test_setup
	count = zeros([2, 2], int32)
	for exp in setup.expectations.tracks:
		p = exp.pin_index
		out = setup.waveforms.track_for_pin(p)
		s_exp = exp.samples
		s_out = out.samples
		n_exp = min(len(s_exp), exp.end)
		n_out = min(len(s_out), out.end)
		for i in xrange(min(n_exp, n_out)):
			e = s_exp[i]
			if not (e & 4):
				j = (e & 2) >> 1
				k = (s_out[i] > Vt) <> (e & 1)
				#print "Pin %2d %4d: e = %d  v = %d    j = %d k = %d" % (p, i, e, s_out[i] > Vt, j, k) ###
				count[j, k] += 1
	print "check_test_results:" ###
	print "count =", count ###
	def percent(good, bad):
		return (100 * good) // (good + bad)
	results = TestResults()
	results.correctness = percent(*count[0])
	results.accuracy = percent(*count[1])
	print "Correctness: %3d%%" % results.correctness
	print "Accuracy:    %3d%%" % results.accuracy
	level.set_test_results(results)
