#--------------------------------------------------------------------------------
#
#   SimChip2 - Setup - Py2App
#
#--------------------------------------------------------------------------------

import os, sys
from distutils.core import setup
import py2app
import setup_common as sc

#--------------------------------------------------------------------------------
#
#   Following are hacks specific to the author's build environment.
#   If they cause you any trouble, take them out.
#
if "PYTHONPATH" in os.environ:
	sys.stderr.write("PYTHONPATH is set")
	sys.exit(1)
if os.environ.get("CC") == "gcc -m32" and "PY2APP_ARCH" not in os.environ:
	sys.stderr.write("PY2APP_ARCH is not set")
	sys.exit(1)
#
#   End hack
#
#--------------------------------------------------------------------------------

def main():
	setup(
		version = sc.version,
		description = sc.description,
		name = sc.app_name,
		app = [sc.main_file],
		data_files = sc.find_resources(),
		options = dict(
			py2app = dict(
				plist = dict(
					CFBundleName = sc.app_name,
					CFBundleSignature = "SChp",
					CFBundleIconFile = "simchip_app",
					CFBundleDocumentTypes = [
						dict(CFBundleTypeName = "SimChip Game",
							CFBundleTypeRole = "Editor",
							CFBundleTypeOSTypes = ["SChG"],
							CFBundleTypeExtensions = ["simchip"],
							CFBundleTypeIconFile = "simchip_game",
							)]
					),
			),
		)
	)

main()
