#--------------------------------------------------------------
#
#   SimChip2 - Resource utilities
#
#--------------------------------------------------------------

import Image as PILImage
from GUI.Resources import get_resource
from GUI import Image, Cursor

def get_image(name, **kwds):
	return Image.from_resource("images/" + name, **kwds)

def get_cursor(name, **kwds):
	return Cursor.from_resource("cursors/" + name, **kwds)

def get_pil_image(name, **kwds):
	return get_resource(load_pil_image, "images/" + name, **kwds)

def load_pil_image(path, **kwds):
	return PILImage.open(path, **kwds)
