#--------------------------------------------------------------
#
#   SimChip2 - Level selection view
#
#--------------------------------------------------------------

from GUI import ModalDialog, GridView, rgb, StdColors
from GUI.StdButtons import CancelButton
from GUI.StdFonts import application_font
from GUI.Geometry import offset_rect
from resources import get_image

tick_image = get_image("green_tick.png")
font = application_font
cell_width = 500
left_margin = 10
text_margin = left_margin + tick_image.width + 10
top_margin = 5
unlocked_color = StdColors.black
locked_color = StdColors.grey
highlight_color = rgb(0, 0.5, 1.0)

cell_height = font.height + 2 * top_margin

#--------------------------------------------------------------

class LevelListView(GridView):

	game = property(lambda self: self.model)
	level_list = property(lambda self: self.game.level_list)

	def __init__(self, game, **kwds):
		GridView.__init__(self, num_rows = 0, num_columns = 0,
			cell_size = (cell_width, cell_height),
			model = game, scrolling = 'v', **kwds)
		self.selection_made = False
		self.update_extent()
	
	def update_extent(self):
		n = len(self.level_list)
		self.num_rows = n
		self.num_columns = 1
	
	def draw_cell(self, c, row, col, rect):
		left, top, right, bottom = rect
		level = self.level_list[row]
		if level is self.game.current_level:
			c.gsave()
			c.fillcolor = highlight_color
			c.fill_rect(rect)
			c.grestore()
		if level.is_completed():
			src = tick_image.bounds
			dst = offset_rect(src, (left + left_margin, top))
			tick_image.draw(c, src, dst)
		c.textcolor = unlocked_color if level.is_unlocked() else locked_color
		c.moveto(left + text_margin, top + top_margin + font.ascent)
		c.show_text("%d. %s" % (row + 1, level.title))
	
	def click_cell(self, row, col, event):
		game = self.game
		level = self.game.get_level_with_index(row)
		if level:
			self.selection_made = game.select_level(level)
	
	def mouse_up(self, event):
		if self.selection_made:
			#self.window.destroy()
			self.window.dismiss(True)

#--------------------------------------------------------------

class LevelListWindow(ModalDialog):

	def __init__(self, game):
		ModalDialog.__init__(self, document = game, title = "Choose Level")
		view = LevelListView(game, size = (300, 500))
		btn = CancelButton()
		self.add(view)
		self.place(btn, top = view + 10, right = view.right - 10)
		self.shrink_wrap(padding = (0, 10))

#--------------------------------------------------------------

def choose_level(game):
	dlog = LevelListWindow(game)
	dlog.present()
