#--------------------------------------------------------------
#
#   SimChip2 - Dymo label rendering
#
#--------------------------------------------------------------

import Image
from ImageFont import truetype
from ImageDraw import Draw
from GUI.Geometry import rect_with_center
from GUI.Resources import find_resource
from GUI.PIL import image_from_pil_image

font_name = "fonts/ImpactLabelReversed.ttf"
font_size = 18

white = (255, 255, 255, 255)
black = (0, 0, 0, 255)
font = truetype(find_resource(font_name), font_size)

def draw_dymo_text(canv, text, pos):
	x, y = pos
	w, h = font.getsize(text)
	pil = Image.new("RGBA", (w, h), black)
	draw = Draw(pil)
	draw.text((0, 0), text, font = font, fill = white)
	img = image_from_pil_image(pil)
	src = img.bounds
	dst = rect_with_center(src, pos)
	img.draw(canv, src, dst)
