#--------------------------------------------------------------
#
#   SimChip2 - Document browser window
#
#--------------------------------------------------------------

from GUI import Window, Button, Row, Column
from html import HTMLView

#--------------------------------------------------------------

class DocBrowserWindow(Window):

	keeps_document_open = False

	game = property(lambda self: self.document)
	current_level = property(lambda self: self.document.current_level)

	def __init__(self, game, **kwds):
		Window.__init__(self, document = game, **kwds)
		game.add_view(self)
		html_view = HTMLView(scrolling = 'hv')
		html_view.content_size = (860, 640)
		self.html_view = html_view
		buttons = self.create_buttons()
		contents = Column([html_view, buttons],
			spacing = 0, expand = 0, equalize = 'w', align = 'lr', anchor = 'ltrb')
		self.add(contents)
		self.shrink_wrap()
		self.current_level_changed()
	
	def create_buttons(self):
		pb = Button("<< Prev", action = 'prev_page')
		nb = Button("Next >>", action = 'next_page')
		nlb = Button("Next Level", action = 'next_level')
		self.next_button = nb
		self.prev_button = pb
		self.next_level_button = nlb
		return Row([pb, nb, None, nlb], padding = (5, 5), expand = 2, equalize = 'w')
	
	def update_title(self):
		level = self.game.current_level
		self.title = "Level %d Instructions" % (level.index + 1)

	def current_level_changed(self, *args):
		self.current_level_page_changed()
		self.update_title()
	
	def current_level_page_changed(self, *args):
		game = self.document
		i = game.current_level_page_index
		n = game.current_level_num_pages
		at_last_page = i == n - 1
		if at_last_page:
			level = game.current_level
			if level.no_test:
				level.mark_completed()
		self.prev_button.enabled = i > 0
		self.next_button.enabled = i < n - 1
		self.next_level_button.enabled = at_last_page and game.next_level_is_unlocked()
		view = self.html_view
		view.set_html(self.document.current_level_html)
	
	def prev_page(self):
		self.game.current_level_page_index -= 1
	
	def next_page(self):
		self.game.current_level_page_index += 1
	
	def next_level(self):
		self.game.select_next_level()

	def close_cmd(self):
		self.hide()
