#--------------------------------------------------------------
#
#   SimChip2 - Pin configuration editing
#
#--------------------------------------------------------------

from GUI import ModalDialog, TextField, RadioButton, RadioGroup, \
	Label, Row, Column, Grid
from GUI.StdButtons import DefaultButton, CancelButton
from GUI.Alerts import stop_alert

class PinConfigEditor(ModalDialog):

	def __init__(self, chip, pin_index):
		ModalDialog.__init__(self, title = "Pin %d Setup" % (pin_index + 1))
		self.chip = chip
		self.pin_index = pin_index
		self.setup = chip.current_setup[pin_index]
		self.create_controls()
		self.load_values()
	
	def create_controls(self):
		self.label_ctrl = TextField(width = 50)
		rb = [
			RadioButton(title = "Switch", value = ('switch', 0)),
			RadioButton(title = "LED", value = ('led', 0)),
			RadioButton(title = "VCC", value = ('terminal', 1)),
			RadioButton(title = "GND", value = ('terminal', 0)),
			RadioButton(title = "NC", value = (None, 0)),
		]
		radio_buttons = Column(rb, spacing = 0)
		self.device_ctrl = RadioGroup(rb)
		controls = Grid([
			[Label("Label"), self.label_ctrl],
			[Label("Device"), radio_buttons],
		], align = 'tl')
		ok_button = DefaultButton("OK")
		cancel_button = CancelButton("Cancel")
		buttons = Row([ok_button, cancel_button], equalize = 'w')
		contents = Column([controls, buttons], align = 'l')
		self.place(contents, left = 20, top = 20)
		self.shrink_wrap()
		self.label_ctrl.become_target()
	
	def load_values(self):
		setup = self.setup
		self.label_ctrl.value = setup.name
		self.device_ctrl.value = (setup.device, setup.state)
	
	def ok(self):
		chip = self.chip
		setup = self.setup
		setup.name = self.label_ctrl.value.upper()
		(setup.device, setup.state) = self.device_ctrl.value
		chip.changed()
		chip.notify('pin_setup_changed', self.pin_index)
		self.dismiss()

#--------------------------------------------------------------

def edit_pin_config(chip, pin_index):
	setup = chip.current_setup
	if not setup.locked:
		dlog = PinConfigEditor(chip, pin_index)
		dlog.present()
	else:
		stop_alert('Cannot change configuration of setup "%s".' % setup.name)
