#--------------------------------------------------------------
#
#   SimChip2 - Chip window
#
#--------------------------------------------------------------

from GUI import Window, ListButton, Row, Label
from device_view import DeviceView
from tool_palette import ToolPalette
from chip_view import ChipView
from speed_control import GameSpeedControl
#from waveform_view import WaveformView
#from waveform_controls import WaveformControls
from controls import RunTestButton
import tools

class ChipWindow(Window):
	#  selected_tool   string
	#  show_voltages   bool

	chip = property(lambda self: self.game.current_chip)
	show_voltages = property(lambda self: self.selected_tool == tools.QGOGGLES)
	
	def __init__(self, game, **kwds):
		Window.__init__(self, position = (0, 40), size = (800, 600),
			document = game, auto_position = False, **kwds)
		self.game = game
		game.add_view(self)
		chip_view = ChipView(scrolling = 'hv')
		dv = [DeviceView(i) for i in (0, 1)]
		#wave_view = WaveformView(game)
		#wave_controls = WaveformControls(game)
		self.device_views = dv
		self.tool_palette = ToolPalette()
		self.speed_control = GameSpeedControl()
		self.setup_selector = ListButton(width = 100, action = 'setup_selected')
		self.chip_view = chip_view
		#self.waveform_view = wave_view
		#self.waveform_controls = wave_controls
		toolbar = Row([
			self.tool_palette,
			None,
			self.speed_control,
			#Label("Setup"),
			self.setup_selector],
			expand = 1)
		buttons = Row([RunTestButton(game)], padding = (5, 5))
		#self.place(wave_controls, left = self, bottom = self, anchor = 'lb')
		#self.place(wave_view, left = self, right = self, bottom = wave_controls, anchor = 'lrb')
		self.place(buttons, right = self, bottom = self, anchor = 'rb')
		bot = buttons
		self.place(dv[0], left = self, top = self, bottom = bot, anchor = 'ltb')
		self.place(dv[1], right = self, top = self, bottom = bot, anchor = 'rtb')
		self.place(toolbar, left = dv[0], right = dv[1], top = self, anchor = 'ltr')
		self.place(chip_view, left = dv[0], right = dv[1],
			top = toolbar, bottom = bot, anchor = 'ltrb')
		self.selected_tool = tools.SELECT
		self.chip_view.become_target()
		self.current_level_changed()
	
	def destroy(self):
		self.game.remove_view(self)
		Window.destroy(self)
	
	def update_title(self):
		game = self.document
		level = game.current_level
		self.title = "%s - Level %d" % (
			game.title, (level.index + 1))
	
	def model_changed(self, model):
		self.update_devices()
	
	def device_state_changed(self, model, pin_index):
		self.update_devices()
	
	def update_devices(self):
		for dv in self.device_views:
			dv.invalidate()
	
	def current_level_changed(self, *args):
		self.update_title()
		self.update_speed_control()
		self.update_setup_list()
		self.update_setup_selector()
		self.update_devices()
		self.update_chip_view_extent()

	def select_tool(self, new_tool):
		old_tool = self.selected_tool
		if old_tool <> new_tool:
			self.selected_tool = new_tool
			self.tool_palette.invalidate()
			self.chip_view.tool_changed()
			if tools.QGOGGLES in (old_tool, new_tool):
				self.chip_view.invalidate()
			for dv in self.device_views:
				dv.tool_changed()
	
	def toggle_show_voltages(self):
		self.show_voltages = not self.show_voltages
		self.tool_palette.invalidate()
		self.chip_view.invalidate()
	
	def setup_list_changed(self, *args):
		self.update_setup_list()
	
	def update_setup_list(self):
		names = self.chip.get_setup_names()
		ctrl = self.setup_selector
		ctrl.titles = names
		ctrl.values = names
		self.selected_setup_changed()

	def selected_setup_changed(self, *args):
		self.update_setup_selector()
	
	def auto_mode_changed(self, *args):
		self.update_setup_selector()

	def update_setup_selector(self):
		selector = self.setup_selector
		chip = self.chip
		selector.value = chip.current_setup.name
		selector.enabled = not chip.auto_running
	
	def setup_selected(self):
		self.chip.select_setup_with_name(self.setup_selector.value)

	def update_chip_view_extent(self):
		self.chip_view.update_extent()
	
	def update_chip_view(self):
		self.chip_view.invalidate()

	def pin_setup_changed(self, model, pin_index):
		self.update_chip_view()

	def cell_changed(self, model, coords):
		self.chip_view.invalidate_cell(coords)

	def chip_state_changed(self, *args):
		self.chip_view.invalidate()
		self.update_devices()

	def update_speed_control(self):
		self.speed_control.value = self.game.game_speed
	
	def game_speed_changed(self, *args):
		self.update_speed_control()

	def game_speed_selected(self):
		self.game.set_game_speed(self.speed_control.value)
