import pygame, random, time
from directicus.sprite import *

import formulas
from stuff import *
from items import *
from spells import *
from battle import *
from monsters import *
from mapevents import *
from npcs import npc


class BorderBox(pygame.Surface):
    col = (255,255,255)
    col2 = (150,150,150)
    bg = (0,0,0)

    def __init__(self, size, b=3):
        pygame.Surface.__init__(self, size)
        self.bgimg = pygame.Surface((size))

        self.bgimg.fill(self.bg)
        if b is not None:
            r = pygame.Rect((0,0), (size[0], size[1]))
            pygame.draw.rect(self.bgimg, self.col, r, b)

            r =  pygame.Rect((0,0), (size[0], size[1]))
            pygame.draw.rect(self.bgimg, self.col2, r, 1)
        self.blit(self.bgimg, (0,0))

    def go(self, dir):
        pass
    def submit(self):
        pass

    def keypress(self):
        pass
    def get_sel(self):
        pass


class TextBox(BorderBox):
    linsize = fontsize + 2
    col = (255,255,255)
    bg = (0,0,0)

    def __init__(self, lines=["Hallo,","Zahme!"],size=(100,100),pad=(5,5),b=3,\
        f=font):
        size = (size[0]+4, size[1]+5)
        self.pad = pad
        self.font = f
        BorderBox.__init__(self, size, b)
        self.lines = []
        self.selected = None
        self.change_lines(lines)

    def change_line(self, nr, text):
        self.lines[nr] = self.font.render(text,1, self.col, self.bg)
        self.redraw()

    def change_lines(self, lines):
        self.lines = []
        for line in lines:
            self.lines.append(self.font.render(line,1, self.col, self.bg))
        self.redraw()

    def redraw(self):
        self.blit(self.bgimg, (0,0))
        x, y = self.pad
        for line in self.lines:
            self.blit(line, (x,y))
            y += self.linsize

class ButtonBox(TextBox):
    def __init__(self, opts=["A", "B"], vis=None, size=None,f=font,pad=(17,5)):
        self.all_opts = []
        for opt in opts:
            self.all_opts.append(opt)
        if not vis:
            vis = len(self.all_opts)
        if not size:
            size = ((len(self.all_opts[0]))*fontsize, self.linsize*vis+8)
        if f is sfont:
            pad = (6,5)
        self.vis = vis
        TextBox.__init__(self, self.all_opts[:vis], size, pad, f=f)
        self.active = False
        self.selected = 0
        self.pointer = arrow
        self.eraser = pygame.Surface(self.pointer.get_size())
        self.eraser.fill(self.bg)

        x, y = 5, 8
        self.pointpos = []
        for opt in xrange(vis):
            self.pointpos.append((x,y))
            y+=self.linsize

    def activate(self):
        self.active = True
        self.select()

    def deactivate(self):
        self.active = False
        self.mark()

    def go(self, dir=0):
        if self.selected+dir>=0 and self.selected+dir<len(self.all_opts):
            self.erase()
            self.selected += dir
            self.select(dir)
            self.bleep()

    def get_sel(self, nr=None):
        if nr is None:
            nr = self.selected
        return self.all_opts[nr]

    def mark(self, nr=None):
        if nr is None:
            nr = self.selected
        if nr >= self.vis:
            nr = nr%self.vis
        self.blit(arrow_mark, self.pointpos[nr])

    def erase(self, nr=None):
        if nr is None:
            nr = self.selected
        if nr >= self.vis:
            nr = nr%self.vis
        self.blit(self.eraser, self.pointpos[nr])

    def select(self, dir=0):
        nr = self.selected
        if nr==0:
            self.change_lines(self.all_opts[:self.vis])
        elif nr >= self.vis:
            nr = nr%self.vis

        if nr==0:
            lines = self.all_opts[self.selected:]
            lines = lines[:self.vis]
            self.change_lines(lines)
        elif nr==self.vis-1 and dir==-1:
            lines = self.all_opts[self.selected-self.vis+1:]
            lines = lines[:self.vis]
            self.change_lines(lines)
        self.blit(self.pointer, self.pointpos[nr])

    def bleep(self):
        pass
        #if not pygame.mixer.get_busy():
            #dc_sfx["sel"].play()

    def update(self, lines):
        while len(lines) <= self.selected:
            self.selected -= 1
        self.all_opts = lines

        nr = self.selected%self.vis
        start = self.selected - nr
        end = start + self.vis
        self.change_lines(self.all_opts[start:end])
        self.redraw()
        self.select()
        self.mark()



class SpellInfoBox(TextBox):
    def __init__(self, size, spell):
        TextBox.__init__(self, lines=[], size=size, f=sfont)

    def show_spell(self, val, name=None):
        lines = [name,""]
        if not name and val.has_key("name"):
            lines[0] = val["name"]
        if val.has_key("mana"):
            lines[1] = "Mana: " + str(val["mana"])
        if val.has_key("desc"):
             lines.extend(gen_lines(val["desc"],30))
        self.change_lines(lines)
        self.redraw()


class SpellBook(pygame.Surface):
    col = (255,255,255)
    size = (250,315)
    def __init__(self):
        pygame.Surface.__init__(self, self.size)
        self.spell_info = SpellInfoBox((self.size[0]-4, 110), circle[0])
        #self.circle_info = SpellInfoBox((self.size[0]-4, 10), circle[0])
        self.listbox = ButtonBox(vis=11, size=(self.size[0]-4,200))
        self.active_box = self.listbox
        self.spellbook = []
        self.mode = 0 #circle selection

    def start(self):
        self.redraw()

    def select(self):
        self.listbox.select()

    def activate(self):
        self.update(self.circ)
        self.listbox.activate()
        self.go(0)

    def deactivate(self):
        self.listbox.deactivate()
        self.redraw()

    def go(self, dir):
        self.listbox.go(dir)
        if self.mode:
            self.spell_info.show_spell(spell[self.get_sel()], self.get_sel())
        else:
            self.spell_info.show_spell(circle[self.listbox.selected])
        self.redraw()

    def submit(self, bol):
        if bol:
            if self.mode:
                return self.listbox.get_sel()
            else:
                self.mode = 1
                self.listbox.update(circle[self.listbox.selected]["spells"])
                self.listbox.selected = 0
                self.go(0)
                self.redraw()
                return None
        else:
            if self.mode:
                self.mode = 0
                self.update(self.circ)
                self.listbox.selected = 0
                self.go(0)
                self.redraw()
                return False
        return True

    def get_sel(self, nr=None):
        return self.listbox.get_sel(nr)

    def mark(self, nr=None):
        self.listbox.mark(nr)

    def erase(self, nr=None):
        self.listbox.erase(nr)
        self.redraw()


    def update(self, circ):
        self.circ = circ
        names = []
        self.mode = False
        for i in xrange(circ):
            names.append(circle[i]["name"])
        self.listbox.update(names)
        self.redraw()

    def redraw(self):
        self.blit(self.spell_info, (0,0))
        #self.blit(self.circle_info, (0,90))
        self.blit(self.listbox, (0, 110))

class SpellBookUI(pygame.Surface):
    size=(780,410)

    def __init__(self, player):
        pygame.Surface.__init__(self, self.size)
        self.player = player
        self.bgimg = pygame.Surface(self.size)
        self.spellbook = SpellBook()
        self.casterbox = ButtonBox(["","","",""], size=(100,80))
        self.targetbox = ButtonBox(["","","",""], size=(100,80))
        self.active_box = None
        self.exit = False

    def start(self):
        self.update_gfx = True
        self.exit = False
        self.bgimg.blit(pygame.display.get_surface(), (-10,-10))
        namelist = []
        for chara in self.player.party:
            namelist.append(chara.name)

        self.casterbox.update(namelist)
        self.targetbox.update(namelist)
        self.spellbook.update(1)

        self.cur_chara =self.player.party[0]
        self.active_box = self.casterbox

        self.action = []
        self.redraw()

    def redraw(self):
        self.update_gfx = False
        self.blit(self.bgimg, (0,0))
        self.blit(self.casterbox, (50,270))
        if self.active_box is self.spellbook:
            self.blit(self.spellbook, (290,50))
        if self.active_box is self.targetbox:
            self.blit(self.spellbook, (290,50))
            self.blit(self.targetbox, (620,270))

    def keypress(self, nr):
        if nr==0:
            self.active_box.go(-1)
        elif nr==1:
            self.active_box.go(1)
        self.redraw()

    def submit(self, bol):
        if bol:
            if self.active_box is self.casterbox:
                self.cur_chara = self.player.party[self.casterbox.selected]
                if not self.cur_chara.cond[0] and not\
                 self.cur_chara.cond[4]:
                    self.action = [self.cur_chara]
                    self.spellbook.update(self.action[0].circle)
                    self.next_menu(self.spellbook)

            elif self.active_box is self.spellbook and\
             self.spellbook.submit(bol):
                spellname = self.active_box.get_sel()
                if self.cur_chara.cur_attr[1]>=spell[spellname]["mana"]:
                    self.action.append(spellname)
                    if spell[spellname]["target"]==friend:
                        self.next_menu(self.targetbox)
                    elif spell[spellname]["target"]==aoe_friend:
                        self.do_action()

            elif self.active_box is self.targetbox:
                self.action=[self.action[0], self.action[1], self.player.party[self.targetbox.selected]]
                self.do_action()
        else:
            if self.active_box is self.casterbox:
                self.exit = 1

            elif self.active_box is self.spellbook and\
             self.spellbook.submit(bol):
                self.action.pop()
                self.next_menu(self.casterbox)

            elif self.active_box is self.targetbox:
                self.action.pop()
                self.spellbook.update(self.cur_chara.circle)
                self.next_menu(self.spellbook)
        self.redraw()

    def do_action(self):
        caster = self.action[0]
        spe = self.action[1]
        caster.cast(self.action[1])

        if spell[spe]["target"]==aoe_friend:
            formulas.cast_aoespell(caster, self.player.party, spe)
        else:
            formulas.cast_spell(caster, self.action[2], spe)
        self.action = [caster, spe]
        dc_sfx["cast"].play()



    def next_menu(self, menu):
        self.active_box.mark()
        self.active_box.deactivate()
        self.active_box = menu
        self.active_box.selected = 0
        self.active_box.select()
        self.active_box.activate()
        self.update_gfx = True

class ItemInfoBox(BorderBox):
    def __init__(self, size, name="map", d1="effdesc", d2="reqdesc", \
        d1t="Effect:", d2t="Requires:"):
        BorderBox.__init__(self, size)
        self.font = sfont
        self.d1 = d1
        self.d2 = d2
        self.d1t = d1t
        self.d2t = d2t
        self.right = self.get_size()[0]
        self.show_item(name, d1, d2, d1t, d2t)
        self.redraw()

    def show_item(self, name, d1=None, d2=None, d1t=None, d2t=None):
        font = sfont
        if d1 and d1t:
            self.d1 = d1
            self.d1t = d1t
        if d2 and d2t:
            self.d2 = d2
            self.d2t = d2t

        self.img = img_unknown
        if item[name].has_key("img"):
            self.img = item[name]["img"]
        self.item = item[name]
        self.title = font.render(name, 1, self.col, self.bg)
        l=""
        if self.item.has_key("desc"):
            l = gen_lines(self.item["desc"], 55)
        self.desc = TextBox(l, (480,115), (0,0),None, f=sfont)

        l1, l2 = "", ""
        if item[name].has_key(self.d1):
            l1=self.d1t+str(self.item[self.d1])
        if item[name].has_key(self.d2):
            l2=self.d2t+str(self.item[self.d2])
            if self.d2=="price":
                l2 = l2 + " Gold"
        elif self.d2=="sellprice":
            if item[name].has_key("price"):
                value = item[name]["price"]/2
                l2=self.d2t+str(value)+" Gold"

        self.effdesc= font.render(l1, 1, self.col, self.bg)
        self.reqdesc= font.render(l2, 1, self.col, self.bg)
        self.redraw()

    def redraw(self):
        self.blit(self.bgimg, (0,0))
        self.blit(self.title, (10,10))
        self.blit(self.img, (self.right-37,5))
        self.blit(self.desc, (10,30))
        self.blit(self.effdesc, (10, 180))
        self.blit(self.reqdesc, (10, 200))


class ContextInfoBox(pygame.Surface):
    bg = (10,10,100)
    #bg = (10,100,10)
    col = (255,255,255)
    def __init__(self, size, player, nr):
        pygame.Surface.__init__(self, size)
        self.fill(self.bg)
        self.player = player
        bsize = (size[0]/2 -1, size[1]/2 -1)
        x, y = 0, 0
        type = item[self.player.inv[0][0]]["type"]
        for p in self.player.party:
            lines = p.gen_contextlist(type)
            bb = BorderBox(bsize)
            bb.blit(sfont.render(lines[0], 1, self.col, (0,0,0)), (5,10))
            bb.blit(sfont.render(lines[1], 1, self.col, (0,0,0)), (5,30))

            self.blit(bb, (x,y))
            if x > 0:
                y = bsize[1]+2
                x = 0
            else:
                x = bsize[0]+2
        bb = BorderBox(bsize)
        self.blit(bb, (bsize[0]+2, bsize[1]+2))


    def redraw(self):
        size = self.get_size()
        self.fill(self.bg)
        bsize = (size[0]/2 -1, size[1]/2 -1)
        type = item[self.player.inv[0][0]]["type"]
        x, y = 0,0
        for p in self.player.party:
            lines = p.gen_contextlist(type)
            bb = BorderBox(bsize)
            bb.blit(sfont.render(lines[0], 1, self.col, (0,0,0)), (5,10))
            bb.blit(sfont.render(lines[1], 1, self.col, (0,0,0)), (5,30))

            self.blit(bb, (x,y))
            if x > 0:
                y = bsize[1]+2
                x = 0
            else:
                x = bsize[0]+2
        bb = BorderBox(bsize)
        self.blit(bb, (bsize[0]+2, bsize[1]+2))

class Chooser(pygame.Surface):
    bg = (30,30,30)
    def __init__(self, size, coords, bsize):
        pygame.Surface.__init__(self, size)
        self.fill(self.bg)
        self.set_colorkey(self.bg)
        self.coords = coords
        self.active = False
        self.selected = 0


        self.selecter = pygame.Surface(bsize)
        self.selecter.fill(self.bg)
        self.selecter.set_colorkey(self.bg)
        r = pygame.Rect((0,0), (bsize[0], bsize[1]))
        pygame.draw.rect(self.selecter, (255,255,0), r, 5)


    def activate(self):
        self.active = True
        self.fill(self.bg)
        self.select()

    def deactivate(self):
        self.active = False
        self.fill(self.bg)
        self.selected = 0

    def go(self, dir):
        if dir>0 and self.active:
            self.selected += dir
            self.select()
        elif dir<0 and self.active:
            self.selected -= dir
            self.select()

    def select(self):
        if self.selected>=len(self.coords):
            self.selected = 0
        elif self.selected < 0:
            self.selected = len(self.coords)-1
        self.fill(self.bg)
        self.blit(self.selecter, self.coords[self.selected])


class PartyBox(TextBox):
    def __init__(self, player):
        TextBox.__init__(self, size=(400, fontsize*6))
        self.player = player
        self.update_party()
    def start(self):
        pass

    def update_party(self):
        party = self.player.party
        lines = []
        self.bgimg.fill(self.bg, pygame.Rect((5,5),(395, 85)))
        y = 5
        for m in party:
            hp = str(int(m.cur_attr[0]))
            mp = str(int(m.cur_attr[1]))
            mhp = str(int(m.attr[0]))
            mmp = str(int(m.attr[1]))
            space = (8 - len(m.name)) * " "
            space2 = (6 - len(mhp)) * " "
            line = m.name +":" + space + hp + "/" + mhp + space2
            line = line + mp + "/" + mmp
            lines.append(line)
            x = 260
            for i in xrange(len(m.cond)):
                if m.cond[i]:
                    self.bgimg.blit(cond_img[i], (x,y))
                x += 17
            y += 17
        gold=sfont.render(str(self.player.gold)+" Gold",1,(255,255,0),self.bg)
        right = self.get_size()[0] - gold.get_size()[0] -10
        self.bgimg.blit(gold, (right,73))


        self.change_lines(lines)

class InventoryUi(pygame.Surface):
    bg = (10,10,50)
    col = (255,255,255)
    def __init__(self, player):
        self.player = player
        size=(780,410)
        pygame.Surface.__init__(self, size)
        self.bgimg = pygame.Surface(size)
        self.invbox = ButtonBox(self.player.gen_itemlist(), 22, (240,380), f=sfont)
        self.active_box = self.invbox
        self.infobox = ItemInfoBox((525,200), self.player.inv[0][0])
        self.charbox = ContextInfoBox((525, 148), self.player, 0)
        bsize = ((261, 73))
        coords=[(0,0),(bsize[0]+2, 0),(0,bsize[1]+2)] #,(bsize[0]+2,bsize[1]+2)
        self.choosebox=Chooser((525, 148),coords, bsize)
        self.redraw()

    def start(self):
        self.exit = 0
        #self.bgimg = pygame.display.get_surface().copy()
        self.bgimg.blit(pygame.display.get_surface(), (-10,-10))
        self.invbox.update(self.player.gen_itemlist())
        self.invbox.selected = 0
        self.invbox.select()
        self.invbox.activate()
        self.active_box = self.invbox
        self.infobox = ItemInfoBox((525,230), self.player.inv[0][0])
        self.charbox = ContextInfoBox((525, 148), self.player, 0)
        self.redraw()

    def redraw(self):
        self.blit(self.bgimg, (0,0))
        self.blit(self.invbox, (4,10))
        self.blit(self.infobox, (252, 10))
        self.blit(self.charbox, (252,247))
        if self.active_box is self.choosebox:
            self.blit(self.choosebox, (252,247))

    def keypress(self, nr):
        if nr==0:
            self.active_box.go(-1)
        elif nr==1:
            self.active_box.go(1)
        self.infobox.show_item(self.invbox.get_sel()[5:])
        self.redraw()

    def submit(self, bol):
        if bol:
            if self.active_box is self.invbox:
                sel = self.invbox.selected
                name = self.invbox.get_sel()[5:]
                if item.has_key(name):
                    if item[name]["type"]==1:
                        #self.active_box.deactivate()
                        self.active_box.mark()
                        self.active_box = self.choosebox
                        self.choosebox.activate()
            elif self.active_box is self.choosebox:
                charnr = self.choosebox.selected
                itemnr = self.invbox.selected
                itemname = self.invbox.get_sel()[5:]
                if self.player.use_item(charnr, itemnr):
                    sel = self.invbox.selected
                    newlist = self.player.gen_itemlist()
                    self.invbox.update(newlist)
                    self.infobox.show_item(self.invbox.get_sel()[5:])

        else:
            if not bol and self.active_box is self.choosebox:
                self.active_box.deactivate()
                self.active_box = self.invbox
                self.invbox.activate()
            elif self.active_box is self.invbox:
                self.exit = 1
        self.charbox.redraw()
        self.redraw()

class BattleUi(pygame.Surface):
    bg = (10,10,50)
    ticklength = 40
    #bg = (10,10,100)
    col = (255,255,255)
    def __init__(self, player):
        self.player = player
        size=(780,410)
        pygame.Surface.__init__(self, size)
        self.bgimg = pygame.Surface(size)
        self.set_colorkey((255,0,255))

        self.battlefield = pygame.Surface((430,200))

        self.partymenu = ButtonBox(["","","",""], size=(100,80))
        actions = ["", "", "", ""]
        self.actionmenu = ButtonBox(actions, size=(100,100))
        self.moremenu = ButtonBox([], size=(240,200), vis=10)
        self.monstermenu = ButtonBox(["","","","","",""],size=(200,100), vis=5)
        self.membmenu = ButtonBox(["","","",""], size=(100, 80))

        self.runmenu=ButtonBox(["Yes, run away!","No, we'll stay."],size=(200,50))

        self.spellmenu = SpellBook()
        self.msgbox = TextBox(["",""], size=(600, 100))

        self.active_box = None

    def start(self, opt):
        self.update_gfx = True
        encounter = opt[0]
        self.encounter = encounter
        self.bgimg.blit(pygame.display.get_surface(), (-10,-10))
        r = pygame.Rect(172, 87, 435,205)
        pygame.draw.rect(self.bgimg, (250,250,250), r, 2)
        r = pygame.Rect(174, 89, 431,201)
        pygame.draw.rect(self.bgimg, (200,200,200), r, 2)

        self.monsters =  []
        for m in encounter:  #load monsters
            self.monsters.append(Monster(m))  #get monsters
        self.alive_monsters = self.monsters[:]

        formulas.monster_boost(self.player.party, self.monsters)

        self.active_box = None
        self.death_anim = []
        self.bbg = opt[1]
        self.msgbox.change_lines(["",""])
        self.battletick = self.ticklength
        self.player_turned = 0
        self.redraw()

        self.battlefield.blit(self.bbg, (0,-32))
        centerx, centery = self.battlefield.get_size()[0]/2,  self.battlefield.get_size()[1]/2
        names = []
        x = centerx-140
        y = centery-60
        for p in self.player.party:  #get names for partymenu
            if p.cond[0]:
                p.image = p.dead_image
            else:
                p.image = p.alive_image
            names.append(p.name)
            p.set_position((x,y), self.battlefield)
            p.action = []
            y+=50
        self.partymenu.update(names)

        if len(self.monsters)==1:
            pos = (centerx+100, centery-10)
            self.monsters[0].set_position(pos, self.battlefield)
            self.battlefield.blit(self.monsters[0].image, self.monsters[0].pos)
        else:
            centerx += 100
            centery -= 10
            coords = [(centerx-50,centery),
                      (centerx+50, centery),
                      (centerx, centery+50),
                      (centerx, centery-50)
                      ]
            for m in self.monsters:
                pos = coords.pop()
                m.set_position(pos, self.battlefield)
                #self.battlefield.blit(m.image, m.pos)
        self.bgimg.blit(self.battlefield, (175,90))
        self.do_shuffle = False
        self.win = False
        self.start_turn()

    def start_turn(self):

        self.player.tick()
        self.update_lists()
        for m in self.alive_monsters:
            m.tick()
        self.update_lists()
        self.tmp_inv = self.player.gen_itemlist(1)
        self.player_turned = 0
        self.initiative = []
        self.active_box = None
        self.update_gfx = True

        lines = []
        for p in self.player.party:
            self.initiative.append(p)
            lines.append(p.name)
        self.membmenu.update(lines)

        lines = []
        for e in self.monsters:  #remove dead monsters
            if not e.cond[0]:
                self.initiative.append(e)
                lines.append(e)

        self.monsters = lines
        if self.do_shuffle:
            random.shuffle(self.initiative)

        self.update_lists()

        if not self.check_win():
            self.turn()


    def update_lists(self):
        self.active_charas = [] # charas that can do something
        self.alive_charas = [] #charas that are not dead = attackeable
        for e in self.player.party:
            if e.get_actionlist():
                self.active_charas.append(e)
            if not e.cond[0]:
                self.alive_charas.append(e)

        self.alive_monsters = []  #monsters that are not dead yet
        for m in self.monsters:
            if not m.cond[0]:
                self.alive_monsters.append(m)

    def playerturn(self):
        self.update_gfx = True
        if self.active_charas == []:
            self.do_shuffle = True
            self.player_turned = 1
            self.active_box = None
            self.msgbox.change_lines([])
        else:
            self.cur_chara = self.active_charas.pop(0)
            self.actionmenu.update(self.cur_chara.get_actionlist())

            nr = self.player.party.index(self.cur_chara)

            self.partymenu.erase(0)
            self.partymenu.erase(1)
            self.partymenu.erase(2)
            self.partymenu.erase(4)
            self.partymenu.mark(nr)

            self.active_box = self.actionmenu
            self.actionmenu.select(0)

            names = []
            for m in self.alive_monsters:
                names.append(m.name)

            self.monstermenu.update(names)

        self.update_gfx = True

    def turn(self):
            if self.initiative:
                self.update_lists()
                e = self.initiative.pop(0)
                if not e.monster and not self.player_turned and \
                    e.get_actionlist:
                    self.initiative.insert(0,e)
                    self.playerturn()
                elif e.monster and e.get_actionlist() and self.alive_charas:
                    e.action = formulas.monster_move(e, self.alive_charas)

                if e.action:
                    self.do_action(e)
                else:
                    self.battletick += self.ticklength
                    self.update()
                self.check_win()
            else:
                self.start_turn()

    def do_action(self, e):
        def new_target(t):
            if t.monster and self.alive_monsters:
                enemies = self.alive_monsters
            elif not t.monster and self.alive_charas:
                enemies = self.alive_charas
            else:
                return None
            return enemies[random.randrange(0,len(enemies))]

        msg, msg2, msg3, prefix = "", "", "", ""

        if e.cond[7]:  #confused
                prefix = e.name+" is confused. "
                prob = random.random()
                if prob < 0.60:  #attack anything
                    all = []
                    all.extend(self.alive_monsters)
                    all.extend(self.player.party)
                    e.action = formulas.monster_move(e, all)
                else:
                    msg = e.name+" is confused and runs around in circles."
                    e.action = []

        if e.get_actionlist()==[] or not e.action:
            if e.cond[1]:
                msg = e.name+" is asleep."
            elif e.cond[6]:
                msg = e.name+" is dazed."

        elif e.action[0]=="Item" and not e.monster:  #use item
            itemname = e.action[1]
            char = e.action[2]
            charnr = self.player.party.index(char)
            self.player.finduseitem(itemname, charnr)
            msg = e.name+" uses "+itemname + " on " + char.name

        elif e.action[0]=="Spell" and spell.has_key(e.action[1]):  #cast spell
            if e.cond[4]:
                msg = e.name + " is mute and cannot cast spells!"
            else:
                if spell[e.action[1]]["target"]<2:
                    t = e.action[2]
                    if e.action[2].monster and e.action[2].cond[0]: #target dead
                        t = new_target(t)
                        if not t:
                            return

                    msg = e.name+" casts "+e.action[1]+" on "+t.name+"."
                    msg2 = t.name + spell[e.action[1]]["msg"]
                    if formulas.cast_spell(e, t, e.action[1]):
                        msg2 = t.name + " resists spell."
                    if t.cond[0]:
                        msg3 = t.name + " is dead!"
                        t.death_anim()
                else:
                    if spell[e.action[1]]["target"]==aoe_friend:
                        t = self.player.party
                        prefix = "All party members"
                        if e.monster:
                            t = self.alive_monsters
                            prefix = "All foes"
                    elif spell[e.action[1]]["target"]==aoe_foe:
                        t = self.alive_monsters
                        prefix = "All foes"
                        if e.monster:
                            t = self.player.party
                            prefix = "All party members"

                    msg = e.name + " casts " + e.action[1] + "."
                    msg2 = prefix + spell[e.action[1]]["msg"]
                    if formulas.cast_aoespell(e, t, e.action[1]):
                        msg2 = prefix + " resist the spell."
                    else:
                        for target in t:
                            if target.cond[0]:
                                target.death_anim()

        elif e.action[0]=="Run":
            for p in self.player.party:
                p.action=[]
            if self.player.run(self.alive_monsters):
                self.show_victory(-1)
                return
            msg = "You didn't manage to escape!"


        elif e.action[0]=="Attack":
            msg = msg + prefix
            t = e.action[1]
            if t.cond[0]:
                t = new_target(t)
                if not t:
                    return

            dam = formulas.attack(e, t)

            if not dam:
                msg = msg + e.name+" misses "+t.name+"."
            else:
                d = int(-dam[0])
                t.change_attr([dam[0]])
                msg=dam[1]+msg+e.name+" hits "+t.name+" and deals "+str(d)+" damage."
                dc_sfx["hit"].play()
                if t.cond[0]:
                    msg2 = t.name + " is dead!"
                    t.death_anim()
        e.action = []
        self.msgbox.change_lines([msg, msg2, msg3])
        self.update_gfx = True

    def redraw(self):
        self.update_gfx = False
        self.bgimg.blit(self.battlefield, (175,90))
        self.blit(self.bgimg, (0,0))

        if self.active_box is None:
            self.blit(self.msgbox, (100,1))
        elif self.active_box is self.msgbox:
            self.blit(self.msgbox, (100,1))
        elif self.active_box:
            self.blit(self.partymenu, (10, 255))
            self.blit(self.actionmenu, (120, 255))
            if self.active_box is self.monstermenu:
                if self.cur_chara.action[0] == "Spell":
                    self.blit(self.spellmenu, (300,50))
                self.blit(self.monstermenu, (565,255))
            elif self.active_box is self.moremenu:
                self.blit(self.moremenu, (4,40))
            elif self.active_box is self.membmenu:
                if self.cur_chara.action[0] == "Spell":
                    self.blit(self.spellmenu, (300,50))
                else:
                    self.blit(self.moremenu, (4,40))
                self.blit(self.membmenu, (250,40))
            elif self.active_box is self.spellmenu:
                self.blit(self.spellmenu, (300,50))
            elif self.active_box is self.runmenu:
                self.blit(self.runmenu, (300,100))


    def keypress(self, nr):
        self.update_gfx = True
        if nr==0 and self.active_box:
            self.active_box.go(-1)
        elif nr==1 and self.active_box:
            self.active_box.go(1)

    def submit(self, bol):
        self.update_gfx = True
        if bol and self.active_box is self.msgbox:
            self.win = 1
        elif bol and self.active_box:
            nr = self.active_box.selected
            action = self.active_box.get_sel()
            if action=="Attack":
                self.cur_chara.action = ["Attack"]
                self.next_menu(self.monstermenu)
            elif action=="Item" and len(self.tmp_inv):
                self.cur_chara.action = ["Item"]
                self.moremenu.update(self.tmp_inv)
                self.next_menu(self.moremenu)
            elif action=="Spell" and self.cur_chara.spells:
                self.cur_chara.action = ["Spell"]
                self.cur_chara.gen_spellbook()
                self.spellmenu.update(self.cur_chara.circle)
                self.next_menu(self.spellmenu)

            elif action=="Run":
                for e in self.encounter:
                    if e=="Chest" or e=="Hidden Chest" or e=="Shadow Legion Chest" or\
                        e=="Mercator" or e=="Brugoth" or e=="Xekolth" or e=="Felimon":
                            print "You cannot escape from this monster."
                    else:
                        self.next_menu(self.runmenu)

            elif self.active_box is self.runmenu:
                nr = self.active_box.selected
                if nr:
                    self.next_menu(self.actionmenu)
                else:
                    for p in self.player.party:
                        p.action=["Run"]
                    self.active_charas=[]
                    self.playerturn()

            elif self.active_box is self.moremenu:
                self.next_menu(self.membmenu)
                self.cur_chara.action.append(action[5:])

            elif self.active_box is self.membmenu:
                if self.cur_chara.action[0] == "Spell":
                    self.cur_chara.cast(self.cur_chara.action[1])

                self.cur_chara.action.append(self.player.party[nr])
                nr = self.moremenu.selected  #update tmp inventorylist
                if self.cur_chara.action[0] == "Item":
                    i = self.tmp_inv[nr]
                    if i.startswith(" "):
                        line = " "
                        c = int(i[2]) - 1
                    else:
                        line = ""
                        a=i.split(")")
                        b=a[0].strip().split("(")[1]
                        c = int(b) - 1
                    if c<= 0:
                        self.tmp_inv.pop(nr)
                    else:
                        self.tmp_inv[nr] = line + "(" +str(c) + i[3:]
                self.playerturn()
            elif self.active_box is self.monstermenu:
                if self.cur_chara.action[0] == "Spell":
                    sname = self.cur_chara.action[1]
                    self.cur_chara.cur_attr[1] -= spell[sname]["mana"]
                self.cur_chara.action.append(self.alive_monsters[nr])
                self.playerturn()

            elif self.active_box is self.spellmenu:
                spellname = self.spellmenu.submit(bol)
                if spellname:
                    if self.cur_chara.cur_attr[1] >= spell[spellname]["mana"]:
                        self.spellmenu.mode = 0
                        self.cur_chara.action.append(spellname)
                        tnr = spell[spellname]["target"]
                        if tnr == foe:
                            self.next_menu(self.monstermenu)  # show monstmenu
                        elif tnr == friend:
                            self.next_menu(self.membmenu)  #show membmenu
                        elif tnr==aoe_foe or tnr==aoe_friend:
                            self.playerturn()  #no target select for aoe
        else:
            if self.active_box is self.runmenu:
                self.next_menu(self.actionmenu)
            if not self.cur_chara.action:
                return
            if self.cur_chara.action[0]=="Spell":
                if self.active_box is self.spellmenu and \
                    self.spellmenu.submit(bol):
                    if self.cur_chara.action:
                        self.cur_chara.action.pop()
                    self.next_menu(self.actionmenu)

                elif self.active_box is self.membmenu or \
                    self.active_box is self.monstermenu:
                    if self.cur_chara.action:
                        self.cur_chara.action.pop()
                    self.next_menu(self.spellmenu)

            elif self.active_box is self.monstermenu or \
               self.active_box is self.moremenu:
                if self.cur_chara.action:
                    self.cur_chara.action.pop()
                self.next_menu(self.actionmenu)

            elif self.active_box is self.membmenu:
                self.cur_chara.action.pop()
                self.next_menu(self.moremenu)


    def next_menu(self, menu):
        self.active_box.mark()
        self.active_box.deactivate()
        self.active_box = menu
        self.active_box.selected = 0
        self.active_box.select()
        self.active_box.activate()
        self.update_gfx = True

    def check_win(self):
        if self.alive_monsters and self.alive_charas:
            return False
        elif self.alive_monsters==[]:
            if self.encounter[0]=="Felimon":
                self.player.you_win = True
            self.show_victory(1)
        else:
            self.show_victory(0)
        return True

    def show_victory(self, bol):
        self.update_gfx = True
        if bol>0:
            msg, msg2 = self.give_loot()
            msg = gen_lines(msg, 66)
            msg.extend(gen_lines(msg2, 66))
            msg.append("Press <Return>")
        elif bol<0:
            msg = ["You escaped!", "", "Press <Return>"]
        else:
            msg = ["You lost...", "", "Press <Return>"]
        self.msgbox.change_lines(msg)
        self.active_box = self.msgbox
        self.player_turned = 1

    def give_loot(self):
        msg, msg2 = formulas.give_loot(self.player, self.encounter)
        if msg:
            return "Victory! You gain " + msg + ".", msg2
        return "Victory!"

    def update(self):
        if self.active_box is None:
            self.battletick += 1
            if self.battletick > self.ticklength:
                self.turn()
                self.battletick = 0
                return True
        elif self.active_box is self.msgbox:
            return True
        return False




class DialogUI(pygame.Surface):
    """ Displays part of longer text, shows next part on submit [RETURN]
    """
    exit = False
    bg = (10,10,50)

    def __init__(self):
        # may get some more UI-elements like a ButtonBox to choose answer,
        # display image of speaking character, etc. ... maybe.
        pygame.Surface.__init__(self, (780, 410))
        self.bgimg = pygame.Surface((780,410))
        self.msgbox = TextBox(size=(600, 100))

    def start(self, name=""):
        self.exit = False
        self.name = name

        msg, self.showname = "", ""
        if npc.has_key(name):
            if npc[name].has_key("msg"):
                msg = npc[name]["msg"]
            if npc[name].has_key("name"):
                self.showname = npc[name]["name"] + ":\n"

        max_lines = 4
        self.msg_pages = []
        for page in msg.split("*:*"):  #manual pagebreaks
            raw_page = gen_lines(page)
            while raw_page:  #automatic pagebreaks
                self.msg_pages.insert(0, raw_page[:max_lines])
                raw_page.__delslice__(0, max_lines)

        self.bgimg.blit(pygame.display.get_surface(), (-10,-10))
        self.blit(self.bgimg, (0,0))
        self.show_text()
        self.redraw()

    def show_text(self):
        if not self.msg_pages:
            self.exit = True
        else:
            msg = self.msg_pages.pop()
            msg.insert(0, self.showname)
            self.msgbox.change_lines(msg)
            if self.msg_pages:
                self.msgbox.blit(dial_arrow, (588, 93))
            else:
                self.msgbox.blit(dial_return, (588, 91))
            self.redraw()

    def submit(self, bol):
        if bol:
            self.show_text()

    def keypress(self, nr):
        #if nr==1:  #down
            #self.show_text()
        pass

    def redraw(self):
        self.blit(self.msgbox, (100,1))


class ContextHelp(TextBox):
    bg = (0,0,0)
    col = (255,255,255)
    def __init__(self, size=(300, fontsize*6)):
        TextBox.__init__(self, ["bla","bla"], size=size, f=sfont)
        self.texts = {
            "inv": ["<Arrow keys> to scroll through list",
                    "<Return> to choose item",
                    "<Esc> to cancel",
                    "<i> to close inventory"],
            "map": ["<Arrow keys> to move",
                    "<Tab> to switch character image",
                    "<Return> to enter city",
                    "<F12> to save game, <s> for spells",
                    "<i> for inventory, <Esc> to quit"
                    ],
            "battle":["<Arrow keys> to scroll through list",
                      "<Return> to choose",
                      "<Esc> to cancel selection",
                    ],
            "city": ["<Arrow keys> to scroll through list",
                     "<Return> to choose item",
                     "<Esc> to cancel selection",
                    ],
            "dialog":["<Return> for next message",
                    ],
            "spellbook":["<Arrow keys> to scroll through list",
                    "<Return> to choose",
                    "<Esc> to cancel",
                    "<s> to close spellbook"]
        }
        self.set_text("map")

    def set_text(self, context="inv"):
        self.change_lines(self.texts[context])


class CityUi(pygame.Surface):
    bg = (10,10,50)
    col = (255,255,255)
    def __init__(self, player, name=None):
        self.player = player
        pygame.Surface.__init__(self, (780,410))
        self.exit = 0
        self.bgimg = pygame.Surface((780,410))
        self.invbox = ButtonBox(self.player.gen_itemlist(1), vis=11, size=(230,200), f=sfont)
        actions = ["Buy", "Sell", "Exit"]
        self.actionbox = ButtonBox(actions, 3, (100,100))
        self.blit(self.bgimg, (0,0))

    def start(self, name):
        if name:
            self.name = name
        else:
            self.name = "Krikal"
        self.bgimg.blit(pygame.display.get_surface(), (-10,-10))
        self.exit = 0
        self.invbox.update(self.player.gen_itemlist(1))
        self.infobox = ItemInfoBox((525,230), self.name)
        self.bgimg.blit(self.infobox, (252, 30))
        self.active_box = self.actionbox
        self.active_box.selected = 0
        self.active_box.select()
        self.action = []
        self.active_box.activate()
        self.redraw()

    def next_menu(self, menu):
        self.active_box.mark()
        self.active_box.deactivate()
        self.active_box = menu
        self.active_box.activate()
        self.active_box.selected = 0
        self.active_box.select()
        self.redraw()

    def redraw(self):
        self.blit(self.bgimg, (0,0))
        self.blit(self.actionbox, (4,255))
        if self.active_box is not self.actionbox:
            self.blit(self.active_box, (4,30))
            self.blit(self.infobox, (252, 30))

    def submit(self, bol):
        if bol and self.active_box:
            action = self.actionbox.get_sel()
            if self.active_box is self.actionbox:
                if action=="Exit":
                    self.exit = 1
                elif action=="Sell":
                    newlist = self.player.gen_itemlist(1)
                    if newlist:
                        self.action = action
                        self.invbox.update(newlist)
                        self.infobox.show_item(self.invbox.get_sel()[5:], d2="sellprice", d2t="Sell for: ")
                        self.next_menu(self.invbox)
                elif action=="Buy":
                    self.action = action
                    self.invbox.update(town_itemlist)
                    self.infobox.show_item(town_itemlist[0][5:], d2="price", d2t="Price: ")
                    self.next_menu(self.invbox)
            elif self.active_box is self.invbox:
                if self.action=="Sell":
                    nr = self.invbox.selected  #update tmp inventorylist
                    itemname = self.invbox.get_sel()[5:]
                    if self.player.findsell(itemname):
                        newlist = self.player.gen_itemlist(1)
                        if newlist:
                            self.invbox.update(newlist)
                            sel = self.invbox.selected
                            self.infobox.show_item(self.invbox.get_sel()[5:])
                            self.redraw()
                        else:
                            self.action = None
                            self.next_menu(self.actionbox)
                elif self.action=="Buy":
                    itemname = self.invbox.get_sel()[5:]
                    if self.player.buy_item(itemname):
                        pass  # Ka-TSCHING!
        else:
            if self.active_box is self.actionbox:
                self.exit = 1
            elif self.active_box is self.invbox:
                self.action = None
                self.infobox.show_item(self.name)
                self.next_menu(self.actionbox)
        self.redraw()

    def keypress(self, nr):
        if nr==0:
            self.active_box.go(-1)
        elif nr==1:
            self.active_box.go(1)
        if self.active_box is self.invbox and self.action is "Sell":
            self.infobox.show_item(self.invbox.get_sel()[5:])
        elif self.active_box is self.invbox and self.action is "Buy":
            self.infobox.show_item(town_itemlist[self.invbox.selected][5:])
        self.redraw()

class WorldMapUi(pygame.Surface):
    bg = (10,10,30)
    #bg  = (10,10,50)
    def __init__(self, player):
        pygame.Surface.__init__(self, (800,600))
        self.update_gfx = False
        self.player = player
        self.tick = 3
        self.uiparts = []
        self.uiparts.append((PartyBox(self.player),(48,432)))
        self.uiparts.append((InventoryUi(self.player),(10,10)))
        self.uiparts.append((BattleUi(self.player), (10,10)))
        self.uiparts.append((CityUi(self.player), (10,10)))
        self.uiparts.append((DialogUI(), (10,10)))
        self.uiparts.append((SpellBookUI(self.player),(10,10)))
        self.contexthelp = ContextHelp()

        self.fill(self.bg)
        #self.set_colorkey(self.bg)
        self.active = None
        self.scrolling = False
        self.redraw(0)

    def activate(self, part, opt=None):
        self.update_gfx = True
        self.active = part
        if opt:
            self.uiparts[self.active][0].start(opt)
        else:
            self.uiparts[self.active][0].start()
        if part==1:
            self.contexthelp.set_text("inv")
        elif part==2:
            self.contexthelp.set_text("battle")
        elif part==3:
            self.contexthelp.set_text("city")
        elif part==4:
            self.contexthelp.set_text("dialog")
        elif part==5:
            self.contexthelp.set_text("spellbook")

        self.redraw(part)

    def deactivate(self, part):
        self.active = None
        self.contexthelp.set_text("map")
        self.redraw(0)

    def redraw(self, part=None):
        self.fill(self.bg)
        if self.active:
            p = self.uiparts[self.active]
            self.blit(p[0], p[1])
        if part is not None:
            p = self.uiparts[part]
            self.blit(p[0], p[1])
        self.blit(self.uiparts[0][0], self.uiparts[0][1])
        self.blit(self.contexthelp, (455, 432))


    def keypress(self, nr):
        if not self.scrolling:
            if self.tick == 0:
                self.uiparts[self.active][0].keypress(nr)
            self.tick += 1
            if self.tick > 3:
                self.scrolling = True
        else:
            self.tick += 1
            if self.tick > 3:
                self.uiparts[self.active][0].keypress(nr)
                self.tick = 0
        self.redraw()

    def submit(self, bol):
        self.uiparts[self.active][0].submit(bol)
        self.uiparts[0][0].update_party()
        self.scrolling = False
        self.tick = 3
        self.redraw(self.active)

    def turn(self):
        if self.active==2:  #if in battle mode
            if self.uiparts[2][0].update():
                self.uiparts[0][0].update_party()
                if self.uiparts[2][0].win:
                    self.deactivate(2)
                    self.activate(0)
                    return True
                return False

    def update(self):
        self.update_gfx = 0
        if self.active==2:
            if self.uiparts[2][0].update_gfx:
                self.update_gfx = 1
                self.uiparts[2][0].redraw()
                self.uiparts[0][0].update_party()
                self.redraw(0)
            return
        self.uiparts[0][0].update_party()
        self.redraw(0)

