import data, pygame

#town_itemlist = []
#for i in town_items:
    #town_itemlist.append(" ~   " + i)

fontsize = 15
font = pygame.font.Font(data.filepath("Courier-Bold"), fontsize)
bfontsize = 30
bfont = pygame.font.Font(data.filepath("Courier-Bold"), bfontsize)
sfontsize = 13
sfont = pygame.font.Font(data.filepath("Courier-Bold"), sfontsize)

battle_bg1 = data.load_image("battle/BattleBG1.png")
battle_bg2 = data.load_image("battle/BattleBG2.png")

arrow = data.load_image("arrow.png")
arrow_mark = data.load_image("arrow_marked.png")
dial_arrow = data.load_image("down.png")
dial_return = data.load_image("return.png")

mchar = data.load_chara("charas/chara1.png")
for line in mchar:
    for img in line:
        img.set_colorkey(img.get_at((0,0)))

mchar2 = data.load_chara("charas/chara2.png")
for line in mchar2:
    for img in line:
        img.set_colorkey(img.get_at((0,0)))

mchar3 = data.load_chara("charas/chara3.png")
for line in mchar3:
    for img in line:
        img.set_colorkey(img.get_at((0,0)))


npc_master = data.load_chara("charas/ordermaster.png")
for line in npc_master:
    for img in line:
        img.set_colorkey(img.get_at((0,0)))

npc_guard = data.load_chara("charas/orderguard.png")
for line in npc_guard:
    for img in line:
        img.set_colorkey(img.get_at((0,0)))

npc_deadmaster = data.load_chara("charas/deadmaster.png")
for line in npc_deadmaster:
    for img in line:
        img.set_colorkey(img.get_at((0,0)))

dc_sfx = {}
def load_sfx(sound_on=True):
    class NoneSound:  #taken from chimp linebyline tutorial
        def play(self): pass

    if sound_on:
        dc_sfx["revive"] = data.load_sound("revive.ogg")
        dc_sfx["cast"] = data.load_sound("revive.ogg")
        dc_sfx["lvlup"] = data.load_sound("lvlup.ogg")
        dc_sfx["mdeath"] = data.load_sound("monsterdth.ogg")
        dc_sfx["pdeath"] = data.load_sound("playerdth.ogg")
        dc_sfx["hit"] = data.load_sound("thud.ogg")
        dc_sfx["sel"] = data.load_sound("select.ogg")
    else:
        dc_sfx["revive"] = NoneSound()
        dc_sfx["lvlup"] = NoneSound()
        dc_sfx["cast"] = NoneSound()
        dc_sfx["mdeath"] = NoneSound()
        dc_sfx["pdeath"] = NoneSound()
        dc_sfx["hit"] = NoneSound()
        dc_sfx["sel"] = NoneSound()



battle_img = {
    "Densha" : mchar[0][0],
    "Shimbun": mchar[1][1],
    "Benkyo" : mchar[0][2],
    "Suika"  : mchar[3][2],
    "Monster": data.load_image("trees/p_forest_WL.png"),
}


img_chest = data.load_image("battle/chest.png",1)
img_chest_o = data.load_image("battle/chest_o.png",1)
img_bosschest = data.load_image("battle/bosschest.png",1)
img_bosschest_o = data.load_image("battle/bosschest_o.png",1)

p_trees = []
p_trees.append(data.load_image("trees/p_forest_WL.png"))  #up
p_trees.append(data.load_image("trees/p_forest_WU.png"))  #down
p_trees.append(data.load_image("trees/p_forest_WS.png"))  #left
tmp = pygame.transform.flip(data.load_image("trees/p_forest_WS.png"), 1, 0)
p_trees.append(tmp)  #right

tmp = pygame.transform.flip(data.load_image("trees/p_forest_CL.png"), 1, 0)
p_trees.append(tmp) #upright
p_trees.append(data.load_image("trees/p_forest_CL.png"))  #upleft
tmp = pygame.transform.flip(data.load_image("trees/p_forest_CU.png"), 1, 0)
p_trees.append(tmp) #downright
p_trees.append(data.load_image("trees/p_forest_CU.png"))  #downleft

for img in p_trees:
    img.set_colorkey((255,255,255))

p_mountains = []
p_mountains.append(data.load_image("mountains/p_mountain_WL.png"))
p_mountains.append(data.load_image("mountains/p_mountain_WU.png"))
p_mountains.append(data.load_image("mountains/p_mountain_WS2.png"))
p_mountains.append(data.load_image("mountains/p_mountain_WS1.png"))

p_mountains.append(data.load_image("mountains/p_mountain_CL.png"))
tmp = pygame.transform.flip(data.load_image("mountains/p_mountain_CL.png"),1,0)
p_mountains.append(tmp)
p_mountains.append(data.load_image("mountains/p_mountain_CU2.png"))
p_mountains.append(data.load_image("mountains/p_mountain_CU1.png"))

p_mountains.append(data.load_image("mountains/p_mountain_T2.png"))
p_mountains.append(data.load_image("mountains/p_mountain_T1.png"))
p_mountains.append(data.load_image("mountains/p_mountain_T4.png"))
p_mountains.append(data.load_image("mountains/p_mountain_T3.png"))


cond_img = [
    data.load_image("conditions/dead.png"),
    data.load_image("conditions/asleep.png"),
    data.load_image("conditions/poison.png"),
    data.load_image("conditions/blind.png"),
    data.load_image("conditions/mute.png"),
    data.load_image("conditions/weak.png"),
    data.load_image("conditions/dazed.png"),
    data.load_image("conditions/confused.png")
]


for img in p_mountains:
    img.set_colorkey((255,255,255))


def gen_lines(text, cols=66):
    word = ""
    line = ""
    lines = []
    msg = text.split(" ")

    for word in msg:
        if len(line + word + " ") >= cols:
            lines.append(line)
            line = ""
            if len(word + " ") < cols:
                line = word + " "
        else:
            line = line + word + " "

        if word.endswith("\n"):
            lines.append(line)
            line = ""

    if line:
        lines.append(line)
    return lines

