# "desc"    Long description
# "effdesc" Short effect description
# "target"  apply to friend or foe
# "atteff"  [hp, mp, at, ac, dm, ep]  between -1000 and 1000
# "siaveff" [str,int,agi,vit] between -100 and 100
# "coneff"  [dead, asleep, poison, blind, mute, weak, dazed, confused]
# "dur"     Duration in turns (0=permanent)
# "mana"    [str, int, agi, vit, warrior, rogue, mage] - Requirements
# "circle"  Circle of Magic

foe = 0
friend = 1
aoe_foe = 2
aoe_friend = 3


spell = {}

# Circle 1 Magic - Basic Support Magic
spell["IN MANI"] = {
    "desc": "Heals minor wounds of target ally.",
    "target": friend,
    "msg": " was healed by 25 HP.",
    "atteff": [25],
    "mana": 5,
    "circle": 1
}

spell["KOR SAR"] = {
    "desc": "Temporarily boosts the strength of target ally.",
    "target": friend,
    "msg": "'s strength was increased by 5.",
    "siaveff": [5],
    "dur": 10,
    "mana": 15,
    "circle": 1
}

spell["KOR IRA"] = {
    "desc": "Temporarily boosts the intelligence of target ally.",
    "target": friend,
    "msg": "'s intelligence was increased by 5.",
    "siaveff": [0,5],
    "dur": 10,
    "mana": 15,
    "circle": 1
}

spell["KOR ANI"] = {
    "desc": "Temporarily boosts the agility of target ally.",
    "target": friend,
    "msg": "'s agility was increased by 5.",
    "siaveff": [0,0,5],
    "dur": 10,
    "mana": 15,
    "circle": 1
}

spell["KOR VIS"] = {
    "desc": "Temporarily boosts the vitality of target ally.",
    "target": friend,
    "msg": "'s vitality was increased by 5.",
    "siaveff": [0,0,0,5],
    "dur": 10,
    "mana": 15,
    "circle": 1
}

spell["DAR ATAK"] = {
    "desc": "Temporarily boosts the attack rating of target ally.",
    "target": friend,
    "msg": "'s attack rating was increased by 10.",
    "atteff": [0,0,10],
    "dur": 10,
    "mana": 20,
    "circle": 1
}

spell["DAR SANCT"] = {
    "desc": "Temporarily boosts the armor class of target ally.",
    "target": friend,
    "msg": "'s armor class was increased by 10.",
    "atteff": [0,0,0,10],
    "dur": 10,
    "mana": 20,
    "circle": 1
}




# Circle 2 Magic - Basic Condition Infliction
spell["VER NUK"] = {
    "desc": "Causes sleepiness on target foe.",
    "target": foe,
    "msg": " is now asleep.",
    "coneff": [0,1],
    "dur": 3,
    "mana": 15,
    "circle": 2
}

spell["IN NOX"] = {
    "desc": "Poisons target foe.",
    "target": foe,
    "msg": " was poisoned.",
    "coneff": [0,0,1],
    "dur": 3,
    "mana": 15,
    "circle": 2
}

spell["GAR WIM"] = {
    "desc": "Blinds target foe.",
    "target": foe,
    "msg": " was blinded.",
    "coneff": [0,0,0,1],
    "dur": 3,
    "mana": 15,
    "circle": 2
}

spell["SOD RIND"] = {
    "desc": "Mutes target foe.",
    "target": foe,
    "msg": " was muted.",
    "coneff": [0,0,0,0,1],
    "dur": 3,
    "mana": 15,
    "circle": 2
}

spell["DES KRA"] = {
    "desc": "Weakens target foe.",
    "target": foe,
    "msg": " was weakened.",
    "coneff": [0,0,0,0,0,1],
    "dur": 3,
    "mana": 15,
    "circle": 2
}

spell["KRIN GUL"] = {
    "desc": "Dazes target foe.",
    "target": foe,
    "msg": " was dazed.",
    "coneff": [0,0,0,0,0,0,1],
    "dur": 3,
    "mana": 15,
    "circle": 2
}

spell["LOH BIN"] = {
    "desc": "Confuses target foe.",
    "target": foe,
    "msg": " was confused.",
    "coneff": [0,0,0,0,0,0,0,1],
    "dur": 3,
    "mana": 15,
    "circle": 2
}




# Circle 3 Magic - Basic Offensive Spells
spell["YLEM RIM"] = {
    "desc": "Throws a small block of ice at target foe.",
    "target": foe,
    "msg": " got hit by a small block of ice for 10 damage.",
    "atteff": [-10],
    "mana": 5,
    "circle": 3
}

spell["VAS FLAM"] = {
    "desc": "Throws a small fireball at target foe.",
    "target": foe,
    "msg": " got hit by a small fireball for 20 damage.",
    "atteff": [-20],
    "mana": 10,
    "circle": 3
}

spell["GRAN HOR"] = {
    "desc": "Throws a small lightning bolt at target foe.",
    "target": foe,
    "msg": " got struck by a small lightning bolt for 30 damage.",
    "atteff": [-30],
    "mana": 15,
    "circle": 3
}

spell["DES VIKUN"] = {
    "desc": "Drains a small amount of mana from target foe.",
    "target": foe,
    "msg": " was drained of 20 MP.",
    "atteff": [0,-20],
    "mana": 10,
    "circle": 3
}



# Circle 4 Magic - Basic Condition Removal
spell["AN KIM"] = {
    "desc": "Removes sleepiness from target ally.",
    "target": friend,
    "msg": " is no longer asleep.",
    "coneff": [0,-1],
    "mana": 20,
    "circle": 4
}

spell["WERA NIH"] = {
    "desc": "Removes poison from target ally.",
    "target": friend,
    "msg": " is no longer poisoned.",
    "coneff": [0,0,-1],
    "mana": 20,
    "circle": 4
}

spell["BUL GAR"] = {
    "desc": "Removes blindness from target ally.",
    "target": friend,
    "msg": " is no longer blinded.",
    "coneff": [0,0,0,-1],
    "mana": 20,
    "circle": 4
}

spell["SRED GRID"] = {
    "desc": "Un-mutes target ally.",
    "target": friend,
    "msg": " is no longer muted.",
    "coneff": [0,0,0,0,-1],
    "mana": 20,
    "circle": 4
}

spell["KORP HARA"] = {
    "desc": "Removes weakness from target ally.",
    "target": friend,
    "msg": " is no longer weakened.",
    "coneff": [0,0,0,0,0,-1],
    "mana": 20,
    "circle": 4
}

spell["NIHU KALA"] = {
    "desc": "Removes daze from target ally.",
    "target": friend,
    "msg": " is no longer dazed.",
    "coneff": [0,0,0,0,0,0,-1],
    "mana": 20,
    "circle": 4
}

spell["RIK AKAR"] = {
    "desc": "Removes confusion from target ally.",
    "target": friend,
    "msg": " is no longer confused.",
    "coneff": [0,0,0,0,0,0,0,-1],
    "mana": 20,
    "circle": 4
}




# Circle 5 Magic - Intermediate Support Magic
spell["IN VAS MANI"] = {
    "desc": "Heals greater wounds of target ally.",
    "target": friend,
    "msg": " was healed by 100 HP.",
    "atteff": [100],
    "mana": 20,
    "circle": 5
}

spell["KOR VAS SAR"] = {
    "desc": "Temporarily boosts the strength of target ally by a considerable amount.",
    "target": friend,
    "msg": "'s strength was increased by 10.",
    "siaveff": [10],
    "dur": 10,
    "mana": 30,
    "circle": 5
}

spell["KOR VAS IRA"] = {
    "desc": "Temporarily boosts the intelligence of target ally by a considerable amount.",
    "target": friend,
    "msg": "'s intelligence was increased by 10.",
    "siaveff": [0,10],
    "dur": 10,
    "mana": 30,
    "circle": 5
}

spell["KOR VAS ANI"] = {
    "desc": "Temporarily boosts the agility of target ally by a considerable amount.",
    "target": friend,
    "msg": "'s agility was increased by 10.",
    "siaveff": [0,0,10],
    "dur": 10,
    "mana": 30,
    "circle": 5
}

spell["KOR VAS VIS"] = {
    "desc": "Temporarily boosts the vitality of target ally by a considerable amount.",
    "target": friend,
    "msg": "'s vitality was increased by 10.",
    "siaveff": [0,0,0,10],
    "dur": 10,
    "mana": 30,
    "circle": 5
}

spell["DAR VAS ATAK"] = {
    "desc": "Temporarily boosts the attack rating of target ally by a considerable amount.",
    "target": friend,
    "msg": "'s attack rating was increased by 20.",
    "atteff": [0,0,20],
    "dur": 10,
    "mana": 40,
    "circle": 5
}

spell["DAR VAS SANCT"] = {
    "desc": "Temporarily boosts the armor class of target ally by a considerable amount.",
    "target": friend,
    "msg": "'s armor class was increased by 20.",
    "atteff": [0,0,0,20],
    "dur": 10,
    "mana": 40,
    "circle": 5
}

spell["KREL MAREN VERTA"] = {
    "desc": "Heals moderate wounds of all party members.",
    "target": aoe_friend,
    "msg": " were healed by 50 HP each.",
    "atteff": [50],
    "mana": 25,
    "circle": 5
}





# Circle 6 Magic - Intermediate Condition Infliction
spell["VER VAS NUK"] = {
    "desc": "Causes sleepiness on all foes.",
    "target": aoe_foe,
    "msg": " are now asleep.",
    "coneff": [0,1],
    "dur": 3,
    "mana": 30,
    "circle": 6
}

spell["IN VAS NOX"] = {
    "desc": "Poisons all foes.",
    "target": aoe_foe,
    "msg": " were poisoned.",
    "coneff": [0,0,1],
    "dur": 3,
    "mana": 30,
    "circle": 6
}

spell["GAR VAS WIM"] = {
    "desc": "Blinds all foes.",
    "target": aoe_foe,
    "msg": " were blinded.",
    "coneff": [0,0,0,1],
    "dur": 3,
    "mana": 30,
    "circle": 6
}

spell["SOD VAS RIND"] = {
    "desc": "Mutes all foes.",
    "target": aoe_foe,
    "msg": " were muted.",
    "coneff": [0,0,0,0,1],
    "dur": 3,
    "mana": 30,
    "circle": 6
}

spell["DES VAS KRA"] = {
    "desc": "Weakens all foes.",
    "target": aoe_foe,
    "msg": " were weakened.",
    "coneff": [0,0,0,0,0,1],
    "dur": 3,
    "mana": 30,
    "circle": 6
}

spell["KRIN VAS GUL"] = {
    "desc": "Dazes all foes.",
    "target": aoe_foe,
    "msg": " were dazed.",
    "coneff": [0,0,0,0,0,0,1],
    "dur": 3,
    "mana": 30,
    "circle": 6
}

spell["LOH VAS BIN"] = {
    "desc": "Confuses all foes.",
    "target": aoe_foe,
    "msg": " were confused.",
    "coneff": [0,0,0,0,0,0,0,1],
    "dur": 3,
    "mana": 30,
    "circle": 6
}



# Circle 7 Magic - Intermediate Offensive Spells
spell["KAL YLEM RIM"] = {
    "desc": "Throws a block of ice at target foe.",
    "target": foe,
    "msg": " was hit by a block of ice for 35 damage.",
    "atteff": [-35],
    "mana": 25,
    "circle": 7
}

spell["KAL VAS FLAM"] = {
    "desc": "Throws a fireball at target foe.",
    "target": foe,
    "msg": " was hit by a fireball for 45 damage.",
    "atteff": [-45],
    "mana": 30,
    "circle": 7
}

spell["KAL GRAN HOR"] = {
    "desc": "Throws a lightning bolt at target foe.",
    "target": foe,
    "msg": " was struck by a lightning bolt for 55 damage.",
    "atteff": [-55],
    "mana": 35,
    "circle": 7
}

spell["DES POR VIKUN"] = {
    "desc": "Drains a large amount of mana from target foe.",
    "target": foe,
    "msg": " was drained of 60 MP.",
    "atteff": [0,-60],
    "mana": 30,
    "circle": 7
}

spell["VAH NUN GERAK"] = {
    "desc": "Causes a small earthquake affecting all at foes location.",
    "target": aoe_foe,
    "msg": " were hit by a small earthquake for 35 damage each.",
    "atteff": [-35],
    "mana": 40,
    "circle": 7
}

spell["NIK GODAR KUN"] = {
    "desc": "Causes a meteor to impact at foes location.",
    "target": aoe_foe,
    "msg": " were hit by a meteor for 45 damage each.",
    "atteff": [-45],
    "mana": 50,
    "circle": 7
}


# Circle 8 Magic - Expert Support Magic
spell["KAL IN VAS MANI"] = {
    "desc": "Heals severe wounds of target ally.",
    "target": friend,
    "msg": " was healed by 250 HP.",
    "atteff": [250],
    "mana": 50,
    "circle": 8
}

spell["KAL KREL MAREN VERTA"] = {
    "desc": "Heals greater wounds of all party members.",
    "target": aoe_friend,
    "msg": " were healed by 150 HP each.",
    "atteff": [150],
    "mana": 50,
    "circle": 8
}

spell["VIT GERAS KIRA"] = {
    "desc": "Revives target ally.",
    "target": friend,
    "msg": " was revived.",
    "coneff": [-1],
    "mana": 40,
    "circle": 8
}

spell["DARG HERT JIN"] = {
    "desc": "Removes all conditions from target ally.",
    "target": friend,
    "msg": " was healed from all conditions.",
    "coneff": [0,-1,-1,-1,-1,-1,-1,-1],
    "mana": 60,
    "circle": 8
}

spell["KREL DARG HERT JIN"] = {
    "desc": "Removes all conditions from all party members.",
    "target": aoe_friend,
    "msg": " were healed from all conditions.",
    "coneff": [0,-1,-1,-1,-1,-1,-1,-1],
    "mana": 110,
    "circle": 8
}


# Circle 9 Magic - Expert Offensive Spells
spell["KAL YLEM VAS RIM"] = {
    "desc": "Throws a large block of ice at target foe.",
    "target": foe,
    "msg": " was hit by a large block of ice for 60 damage.",
    "atteff": [-60],
    "mana": 45,
    "circle": 9
}

spell["KAL VAS MERGIN FLAM"] = {
    "desc": "Throws a large fireball at target foe.",
    "target": foe,
    "msg": " was hit by a large fireball for 75 damage.",
    "atteff": [-75],
    "mana": 55,
    "circle": 9
}

spell["KAL GRAN VAS HOR"] = {
    "desc": "Throws a large lightning bolt at target foe.",
    "target": foe,
    "msg": " was struck by a large lightning bolt for 80 damage.",
    "atteff": [-80],
    "mana": 65,
    "circle": 9
}

spell["DES POR VAS VIKUN"] = {
    "desc": "Drains a huge amount of mana from target foe, largely disturbing his magic abilities.",
    "target": foe,
    "msg": " was drained of 120 MP.",
    "atteff": [0,-120],
    "mana": 60,
    "circle": 9
}

spell["KAL VAH NUN VAS GERAK"] = {
    "desc": "Causes a enourmous earthquake affecting all at foes location.",
    "target": aoe_foe,
    "msg": " were hit by a enourmous earthquake for 70 damage each.",
    "atteff": [-70],
    "mana": 70,
    "circle": 9
}


spell["KAL YLEM NIk GARU VEKI"] = {
    "desc": "Summons a blizzard at foes location.",
    "target": aoe_foe,
    "msg": " were hit by a blizzard for 100 damage each.",
    "atteff": [-100],
    "mana": 90,
    "circle": 9
}


spell["KAL NIK GODAR VAS KUN"] = {
    "desc": "Causes a meteor shower to impact at foes location.",
    "target": aoe_foe,
    "msg": " were hit by a meteor shower for 150 damage each.",
    "atteff": [-150],
    "mana": 120,
    "circle": 9
}








circle= [0,1,2,3,4,5,6,7,8]

circle[0] = {
    "name": "Circle 1 Magic",
    "desc": "Circle 1 Magic - Basic Support Magic",
    "maxmana": 20,
    "spells": []
}

circle[1] = {
    "name": "Circle 2 Magic",
    "desc": "Circle 2 Magic - Basic Condition Infliction",
    "maxmana": 15,
    "spells": []
}

circle[2] = {
    "name": "Circle 3 Magic",
    "desc": "Circle 3 Magic - Basic Offensive Spells",
    "maxmana": 15,
    "spells": []
}

circle[3] = {
    "name": "Circle 4 Magic",
    "desc": "Circle 4 Magic - Basic Condition Removal",
    "maxmana": 20,
    "spells": []
}

circle[4] = {
    "name": "Circle 5 Magic",
    "desc": "Circle 5 Magic - Intermediate Support Magic",
    "maxmana": 40,
    "spells": []
}

circle[5] = {
    "name": "Circle 6 Magic",
    "desc": "Circle 6 Magic - Intermediate Condition Infliction",
    "maxmana": 30,
    "spells": []
}

circle[6] = {
    "name": "Circle 7 Magic",
    "desc": "Circle 7 Magic - Intermediate Offensive Spells",
    "maxmana": 50,
    "spells": []
}

circle[7] = {
    "name": "Circle 8 Magic",
    "desc": "Circle 8 Magic - Expert Support Magic",
    "maxmana": 110,
    "spells": []
}

circle[8] = {
    "name": "Circle 9 Magic",
    "desc": "Circle 9 Magic - Expert Offensive Spells",
    "maxmana": 120,
    "spells": []
}



for i in spell.keys():
    circle[spell[i]["circle"]-1]["spells"].append(i)

#for i in circle:
    #print i["name"], len(i["spells"])
