import data, pygame
from directicus.gfx import *
from stuff import *
from mapevents import *
from npcs import npc

def load_map(filename):
    try:
        f = data.load("maps/" + filename, "r")
        map = {}
        map["name"] = filename
        map["tileset"]=f.readline().strip()
        w, h = f.readline().strip().split(",")
        map["size"] = (int(w), int(h))
        for line in f:
            x, y, tx, ty, b = line.strip().split(",")
            map[int(x),int(y)] = [(int(tx), int(ty)), int(b)]
        f.close()
        return map
    except:
        return None

def save_map(filename, map):
    f = data.load("maps/"+filename, "w")
    f.write(map["tileset"]+"\n")
    w, h = map["size"]
    f.write(str(w)+","+str(h)+"\n")
    for y in xrange(h):
        for x in xrange(w):
            t, b = (0,0), 1
            if map.has_key((x,y)):
                t = map[x,y][0]
            tx, ty = t
            if tx < 3:
                b = 0
            line = str(x)+","+str(y)+","+str(tx)+","+str(ty)+","+str(b)+"\n"
            f.write(line)
    f.close()

def gen_map(size, tileset, name):
    map = {}
    map["size"] = size
    map["tileset"] = tileset
    map["name"] = name

    for y in xrange(size[1]):
        for x in xrange(size[0]):
            tile = [(0,0),0]
            if x<11 or y<5 or x>size[0]-11 or y>size[1]-6:
                tile = [(4,0), 1]
            map[x,y] = tile
    return map


class MapImg(pygame.Surface):
    def __init__(self, map):
        self.tileset = data.load_tileset(map["tileset"])
        w, h = map["size"]
        self.map = map
        self.msize = map["size"]
        self.size = (w*32, h*32)
        pygame.Surface.__init__(self, self.size)
        self.treeparts = p_trees
        self.mountainparts = p_mountains

        for y in xrange(h):
            for x in xrange(w):
                if map.has_key((x,y)):
                    tx, ty = map[x,y][0]
                    self.blit(self.tileset[tx][ty], (x*32, y*32))

        self.overlap((0,0,w,h))
        self.draw_other()

    def draw_other(self):
        """
        Draws chests and npcs
        """
        img_mercator = data.load_image("battle/monster3.png", 1)
        img_brugoth = data.load_image("battle/monster4.png", 1)
        img_xekolth = data.load_image("battle/monster5.png", 1)
        img_felimon = data.load_image("battle/orderchest2.png", 1)
        img_castleguard = data.load_image("battle/monster1.png", 1)
        img_zjokrax = data.load_image("battle/monster6.png", 1)

        name = self.map["name"]
        if mapevents.has_key(name):
            for ev in mapevents[name]:
                if ev[1]==1:  #draw chests
                    if ev[2]=="Chest":
                        self.draw_special(ev[0], img_chest)
                    elif ev[2]=="Shadow Legion Chest":                  ###monsternames
                        self.draw_special(ev[0], img_bosschest)
                    elif ev[2]=="Hidden Chest":
                        self.draw_special(ev[0], img_felimon)
                    elif ev[2]=="Mercator":
                        self.draw_special(ev[0], img_mercator)
                    elif ev[2]=="Brugoth":
                        self.draw_special(ev[0], img_brugoth)
                    elif ev[2]=="Xekolth":
                        self.draw_special(ev[0], img_xekolth)
                    elif ev[2]=="Felimon":
                        self.draw_special(ev[0], img_felimon)
                    elif ev[2]=="Castle Guard":
                        self.draw_special(ev[0], img_castleguard)
                    elif ev[2]=="Lord Zjokrax":
                        self.draw_special(ev[0], img_zjokrax)
                elif ev[1]==4:  #draw npcs
                    self.draw_npc(ev[0], ev[2])
                elif ev[1]==5: #blocking
                    self.draw_special(ev[0], blocking=True)

    def draw_npc(self, pos, id, face=None):
        if npc.has_key(id):
            n = npc[id]
            if n.has_key("img"):
                look = face
                if face==None and n.has_key("look"):
                    look = n["look"]
                if look > 3:
                    look = 3
                self.draw_special(pos) #re-blit tile background
                self.draw_special(pos, n["img"][look][0], True) #blit npc

    def draw_special(self, coord, img=None, blocking=None):
        x, y = coord
        if not img:
            tx, ty = self.map[x,y][0]
            img = self.tileset[tx][ty]
        if blocking is not None:
            self.map[x,y][1] = blocking
        self.blit(img, (x*32,y*32))


    def draw_overlap(self, area, type, parts):
        from_x, from_y, to_x, to_y = area
        for y in xrange(from_y, to_y):
            for x in xrange(from_x, to_x):
                if self.map.has_key((x,y)):
                    if self.map[x,y][0][0]<2 or \
                    (self.map[x,y][0][0]==5 and self.map[x,y][0][1]>=14):
                        chk = [(x, y-1),   #up
                                 (x, y+1),   #down
                                 (x-1, y),   #left
                                 (x+1, y),   #right
                                 (x-1, y-1), #upleft
                                 (x+1, y-1), #upright
                                 (x-1, y+1), #downleft
                                 (x+1, y+1), #downright
                                 ]
                        check = []
                        for c in chk:
                            check.append(self.check_tile(c, type))

                        if check[4]:
                            self.draw_part((x,y), parts[7])
                        if check[5]:
                            self.draw_part((x,y), parts[6])
                        if check[6]:
                            self.draw_part((x,y), parts[5])
                        if check[7]:
                            self.draw_part((x,y), parts[4])

                        if check[0]:
                            self.draw_part((x,y), parts[1])
                        if check[1]:
                            self.draw_part((x,y), parts[0])
                        if check[2]:
                            self.draw_part((x,y), parts[3])
                        if check[3]:
                            self.draw_part((x,y), parts[2])

                        if len(parts)>8:
                            if check[0] and check[2] and check[4]:
                                self.draw_part((x,y), parts[11])
                            if check[0] and check[3] and check[5]:
                                self.draw_part((x,y), parts[10])
                            if check[1] and check[2] and check[6]:
                                self.draw_part((x,y), parts[8])
                            if check[1] and check[3] and check[7]:
                                self.draw_part((x,y), parts[9])

    def overlap(self, area):
        if self.map["tileset"]=="p_worldmap.png":
            self.draw_overlap(area, (3,0), self.treeparts)
            self.draw_overlap(area, (4,0), self.mountainparts)

    def draw_part(self, (x, y), img):
        self.blit(img, (x*32, y*32))

    def check_tile(self, (x, y), type):
        if self.map.has_key((x,y)):  #grass only?
            return self.map[x,y][0]==type
        return 0

