# "desc"    Long description
# "effdesc" Short effect description
# "reqdesc" Requirement-text
# "type"    useabe/weapon, etc.
# "atteff"  [hp, mp, at, ac, dm, ep]  between -1000 and 1000
# "siaveff" [str,int,agi,vit] between -100 and 100
# "coneff"  [dead, asleep, poison, blind, mute, weak, dazed, confused]
# "dur"     Duration in turns (0=permanent)
# "req"     [str, int, agi, vit, warrior, rogue, mage] - Requirements


import data

img_unknown = data.load_image("items/unknown.png")

quest_item = 0
useable = 1
weapon = 2
a_head = 3
a_body = 4
a_hands = 5
a_legs = 6
a_feet = 7
a_ring = 8
a_shield = 9

item = {}


###Quest-Items
item["Map"] = {
    "type": quest_item,
    "img": data.load_image("items/map.png",1),
    "desc": "A detailed map of Kiralia."
}

item["Piece of Magical String"] = {
    "type": quest_item,
    "img": data.load_image("items/stringpiece.png",1),
    "desc": "This is one piece of the Magical String that was given by the divine goddess Kira to banish Felimon, Lord of the Shadows, from the world of Kiralia. You have to find all four pieces scattered on the surface of Kiralia."
}

item["Magical String"] = {
    "type": quest_item,
    "img": data.load_image("items/string.png",1),
    "desc": "After you found the last Piece of Magical String, all pieces set themselves together to this Magical String. You should now return to the Order of the Rising Sun to seal the Forbidden Chest before more Shadows pass through from the Sphere of Chaos."
}

item["Godly Plate of the Whale"] = {
    "type": quest_item,
    "img": data.load_image("items/gpotw.png",1),
    "desc": "This armor basically does not exist, so it is quite a bit suspicious how you obtained it. As it does not exist, you can of course not equip it. Sadly, this armor also has such a high value that nobody will ever be able to buy it from you - I guess you are stuck with it.",
    "effdesc": "AC+82, AC+197%, HP+100, Indestructible"
}


###Condition-Removal
item["Divine Charm"] = {
    "type": useable,
    "img": data.load_image("items/divinecharm.png",1),
    "desc": "A small blessed charm in the shape of Goddess Kira. This charm is able to revive the recently deceased.",
    "effdesc": "Revives the Dead",
    "atteff": [10],
    "coneff": [-1],
    "price": 50
}

item["Antidote"] = {
    "type": useable,
    "img": data.load_image("items/antidote.png",1),
    "desc": "A strong potion which is able to negate even the strongest poisons.",
    "effdesc": "Cures poison",
    "coneff": [0,0,-1],
    "price": 25
}

item["Shimmering Mushroom"] = {
    "type": useable,
    "img": data.load_image("items/shimush.png",1),
    "desc": "It is widely known, that this mushroom is able to cure the blind.",
    "effdesc": "Cures Blindness",
    "coneff": [0,0,0,-1],
    "price": 25
}

item["Singing Daisy"] = {
   "type": useable,
   "img": data.load_image("items/sindai.png",1),
   "desc": "This flower can mainly be found in mountain regions of Kiralia. It received its name due to the humming noise a field fo these flowers do when wind the blows through it.",
   "effdesc": "Cures Mute",
   "coneff": [0,0,0,0,-1],
   "price": 25
}

item["Energizing Beans"] = {
    "type": useable,
    "img": data.load_image("items/enerbean.png",1),
    "desc": "These Beans can be bought everywhere in Kiralia and are mostly used to brew warm potions which are focusing the mind and remove spleepiness.",
    "effdesc": "Cures Weakness and awakes from Sleep",
    "coneff": [0,-1,0,0,0,-1],
    "price": 25
}

item["Sentinent Root"] = {
    "type": useable,
    "img": data.load_image("items/senroo.png",1),
    "desc": "This root is able to sharpen or regain the awareness of someones sourroundings.",
    "effdesc": "Cures Drowsiness",
    "coneff": [0,0,0,0,0,0,-1],
    "price": 25
}

item["Hermits Herb"] = {
    "type": useable,
    "img": data.load_image("items/herher.png",1),
    "desc": "This Herb is mostly used in rituals to sense parallel worlds, but also works fine in focusing the mind of the confused.",
    "effdesc": "Cures Confusion",
    "coneff": [0,0,0,0,0,0,0,-1],
    "price": 25
}


###Health-Potions
item["Small Health Potion"] = {
    "type": useable,
    "img": data.load_image("items/health1.png",1),
    "desc": "This potion provides a small boost of health",
    "effdesc": "HP+25",
    "atteff": [25],
    "price": 12
}

item["Health Potion"] = {
    "type": useable,
    "img": data.load_image("items/health2.png",1),
    "desc": "This potion provides a boost of health",
    "effdesc": "HP+50",
    "atteff": [50],
    "price": 25
}

item["Large Health Potion"] = {
    "type": useable,
    "img": data.load_image("items/health3.png",1),
    "desc": "This potion provides a large boost of health",
    "effdesc": "HP+100",
    "atteff": [100],
    "price": 50
}

item["Massive Health Potion"] = {
    "type": useable,
    "img": data.load_image("items/health4.png",1),
    "desc": "This potion provides a decent boost of health",
    "effdesc": "HP+200",
    "atteff": [200],
    "price": 100
}


####Mana-Potions
item["Small Mana Potion"] = {
    "type": useable,
    "img": data.load_image("items/mana1.png",1),
    "desc": "This potion provides a small boost of mental energy",
    "effdesc": "MP+25",
    "atteff": [0,25],
    "price": 12
}

item["Mana Potion"] = {
    "type": useable,
    "img": data.load_image("items/mana2.png",1),
    "desc": "This potion provides a boost of mental energy",
    "effdesc": "MP+50",
    "atteff": [0,50],
    "price": 25
}

item["Large Mana Potion"] = {
    "type": useable,
    "img": data.load_image("items/mana3.png",1),
    "desc": "This potion provides a large boost of mental energy",
    "effdesc": "MP+100",
    "atteff": [0,100],
    "price": 50
}

item["Massive Mana Potion"] = {
    "type": useable,
    "img": data.load_image("items/mana4.png",1),
    "desc": "This potion provides a decent boost of mental energy",
    "effdesc": "MP+200",
    "atteff": [0,200],
    "price": 100
}


###Ether-Potions
item["Small Ether Potion"] = {
    "type": useable,
    "img": data.load_image("items/ether1.png",1),
    "desc": "This potion provides a small boost of health and mental energy",
    "effdesc": "HP+25, MP+25",
    "atteff": [25,25],
    "price": 25
}

item["Ether Potion"] = {
    "type": useable,
    "img": data.load_image("items/ether2.png",1),
    "desc": "This potion provides a boost of health and mental energy",
    "effdesc": "HP+50, MP+50",
    "atteff": [50,50],
    "price": 50
}

item["Large Ether Potion"] = {
    "type": useable,
    "img": data.load_image("items/ether3.png",1),
    "desc": "This potion provides a large boost of health and mental energy",
    "effdesc": "HP+100, MP+100",
    "atteff": [100,100],
    "price": 100
}

item["Massive Ether Potion"] = {
    "type": useable,
    "img": data.load_image("items/ether4.png",1),
    "desc": "This potion provides a decent boost of health and mental energy",
    "effdesc": "HP+200, MP+200",
    "atteff": [200,200],
    "price": 200
}


###Consumables
item["Cookie"] = {
    "type": useable,
    "img": data.load_image("items/cookie.png",1),
    "desc": "A yummy cookie",
    "effdesc": "HP+5, MP+5",
    "atteff": [5, 5],
    "price": 5
}

item["Cake"] = {
    "type": useable,
    "img": data.load_image("items/cake.png",1),
    "desc": "A very yummy cake",
    "effdesc": "HP+10, MP+10",
    "atteff": [10, 10],
    "price": 10
}

item["Flask of Water"] = {
    "type": useable,
    "img": data.load_image("items/flawat.png",1),
    "desc": "A small flask filled with fresh water.",
    "effdesc": "HP+5, MP+5",
    "atteff": [5, 5],
    "price": 5
}

item["Bread"] = {
    "type": useable,
    "img": data.load_image("items/bread.png",1),
    "desc": "A leaf of bread",
    "effdesc": "HP+10, MP+10",
    "atteff": [10, 10],
    "price": 10
}

item["Red Wine"] = {
    "type": useable,
    "img": data.load_image("items/redwin.png",1),
    "desc": "A bottle of the finest red wine available in Kiralia.",
    "effdesc": "HP-5, MP+15",
    "atteff": [-5, 15],
    "price": 20
}

item["Rum"] = {
    "type": useable,
    "img": data.load_image("items/rum.png",1),
    "desc": "A bottle of the strongest rum available in this dimension.",
    "effdesc": "STR+7, INT-5, AGI-4, VIT+3, Causes Blindness",
    "siaveff": [7, -5, -4, 3],
    "coneff": [0,0,0,1],
    "dur": 30,
    "price": 50
}


###Elixirs
item["Elixir of Strength"] = {
    "type": useable,
    "img": data.load_image("items/elixstr.png",1),
    "desc": "This elixir permantenly boosts your strength by 2 points",
    "effdesc": "Permanently STR+2",
    "siaveff": [2],
    "dur": 0,
    "price": 1500
}

item["Elixir of Intelligence"] = {
    "type": useable,
    "img": data.load_image("items/elixint.png",1),
    "desc": "This elixir permantenly boosts your intelligence by 2 points",
    "effdesc": "Permanently INT+2",
    "siaveff": [0, 2],
    "dur": 0,
    "price": 1500
}

item["Elixir of Agility"] = {
    "type": useable,
    "img": data.load_image("items/elixagi.png",1),
    "desc": "This elixir permantenly boosts your agility by 2 points",
    "effdesc": "Permanently AGI+2",
    "siaveff": [0, 0, 2],
    "dur": 0,
    "price": 1500
}

item["Elixir of Vitality"] = {
    "type": useable,
    "img": data.load_image("items/elixvit.png",1),
    "desc": "This elixir permantenly boosts your vitality by 2 points",
    "effdesc": "Permanently VIT+2",
    "siaveff": [0, 0, 0, 2],
    "dur": 0,
    "price": 1500
}


###Boss-Rewards
item["Shadow Ring"] = {
    "type": useable,
    "img": data.load_image("items/shadowring.png",1),
    "desc": "This powerfull ring enhances all attributes of the wielder by a considerable amount.",
    "effdesc": "Permanently STR+10, INT+10, AGI+10 VIT+10",
    "siaveff": [10, 10, 10, 10],
    "dur": 0,
    "price": 20000
}

item["Shadow Charm"] = {
    "type": useable,
    "img": data.load_image("items/shadowcharm.png",1),
    "desc": "This powerfull charm enhances all attributes of the wielder by a considerable amount.",
    "effdesc": "Permanently STR+10, INT+10, AGI+10 VIT+10",
    "siaveff": [10, 10, 10, 10],
    "dur": 0,
    "price": 20000
}

item["Shadow Bracelet"] = {
    "type": useable,
    "img": data.load_image("items/shadowbracelet.png",1),
    "desc": "This powerfull bracelet enhances all attributes of the wielder by a considerable amount.",
    "effdesc": "Permanently STR+10, INT+10, AGI+10 VIT+10",
    "siaveff": [10, 10, 10, 10],
    "dur": 0,
    "price": 20000
}

###City Descriptions
# Temple-Region
item["Bari"] = {
    "type": quest_item,
    "desc": "One of the three smaller villages near the temple of the Order of the Rising Sun. Not many travelers are usually coming by and normally, life is a very calm business here."
}

item["Lerkos"] = {
    "type": quest_item,
    "desc": "One of the three smaller villages near the temple of the Order of the Rising Sun. Not many travelers are usually coming by and normally, life is a very calm business here."
}

item["Warso"] = {
    "type": quest_item,
    "desc": "One of the three smaller villages near the temple of the Order of the Rising Sun. Not many travelers are usually coming by and normally, life is a very calm business here."
}

#Capitol-Region
item["Urgol"] = {
    "type": quest_item,
    "desc": "One of the many villages that can be found in this dense populated region."
}

item["Burast"] = {
    "type": quest_item,
    "desc": "One of the many villages that can be found in this dense populated region."
}

item["Nigun"] = {
    "type": quest_item,
    "desc": "The only village in the Capital Region who suffers from the massing Shadow Legions, since the Forbidden Chest openend some days ago. The villagers are nervous and some are already leaving Nigun to find a home in one of the other towns or villages in this region."
}

item["Berikan"] = {
    "type": quest_item,
    "desc": "One of the towns nearby the capital city Krikal. This town benefits from its near to Krikal in terms of goods, traderouts, and many immigrants who want to build an existence in this region."
}

item["Dolgin"] = {
    "type": quest_item,
    "desc": "One of the many villages that can be found in this dense populated region."
}

item["Palago"] = {
    "type": quest_item,
    "desc": "One of the towns nearby the capital city Krikal. This town benefits from its near to Krikal in terms of goods, traderouts, and many immigrants who want to build an existence in this region."
}

item["Sandar"] = {
    "type": quest_item,
    "desc": "One of the many villages that can be found in this dense populated region."
}

item["Krikal"] = {
    "type": quest_item,
    "desc": "The captial city of Kiralia. All kinds of people - regardless of which ethnicity - can be found here and the greatest Houses of Kiralia are located in this city. No word has spread into this city about the incidence at the temple until now, and it is your task to make sure this problem is resolved before anyone of the Kiralian highlords knows about it."
}

item["Werto"] = {
    "type": quest_item,
    "desc": "One of the towns nearby the capital city Krikal. This town benefits from its near to Krikal in terms of goods, traderouts, and many immigrants who want to build an existence in this region."
}

item["Verkos"] = {
    "type": quest_item,
    "desc": "This town is a bit off from the capital city Kerikal, but still profits from its excellent placement. The nearby river and cross-road made this town to one of the more important marketplaces in Kiralia, positively influencing the growth rates of both, population and wealth."
}

item["Feria"] = {
    "type": quest_item,
    "desc": "One of the towns nearby the capital city Krikal. This town benefits from its near to Krikal in terms of goods, traderouts, and many immigrants who want to build an existence in this region."
}

item["Hidan"] = {
    "type": quest_item,
    "desc": "One of the many villages that can be found in this dense populated region."
}

item["Rekor"] = {
    "type": quest_item,
    "desc": "One of the many villages that can be found in this dense populated region."
}

#Outer-Region
item["Swegal"] = {
    "type": quest_item,
    "desc": "One small village located in the forests of the Outer Regions. Not much is happening here and the villagers are happy to see someone from outside the village from time to time."
}

item["Perga"] = {
    "type": quest_item,
    "desc": "One small village located in the forests of the Outer Regions. Not much is happening here and the villagers are happy to see someone from outside the village from time to time."
}

item["Mara"] = {
    "type": quest_item,
    "desc": "This town is the richest location in the Outer Regions. Many traderoutes into the Outer Regions are passing this town, making it to one of the most important marketplaces in Kiralia."
}

item["Turgin"] = {
    "type": quest_item,
    "desc": "A small village located in the mountains of the Outer Regions. Life was calm here before the Forbidden Chest opened some days ago and the Shadow Legion starting to show activity around the nearby castle. The villagers are a bit worried what the futuer might hold for them."
}

#Cliff-Region
item["Reistan"] = {
    "type": quest_item,
    "desc": "One small village located at the border to Shadow Kingdom. Life was very calm here until the Forbidden Chest opened some days ago and the Shadow Legions again started to ravage these lands. The villagers are now hiding in their buildings - hoping that this bad dream will go away as quickly as it came."
}
