import data, pygame, eventnet, time, random, pickle
from pygame.locals import *

from directicus.engine import State

from ui import *
from map import *
from items import *
from entity import *
from mapevents import *
from battle import *
from monsters import *

soundOn = 1
try:
    pygame.mixer.init()
    load_sfx()
except:
    print "Sound and music disabled."
    soundOn = 0
    load_sfx(False)


player = Player()
event_backup = mapevents.copy()
rnd_encprob = 200
ui_world = WorldMapUi(player)


def change_music(filename=None, loop=-1, vol=0.6):
    if soundOn:
        try:
            if not filename:
                pygame.mixer.music.fadeout(1000)
                return
            pygame.mixer.music.stop()
            music_map=pygame.mixer.music.load(data.filepath("bgm/"+filename))
            #pygame.mixer.music.set_volume(vol)
            pygame.mixer.music.play(loop)
        except:
            print "Error loading music file: " + filename

class WorldMap(State):
    bg=(10,10,10)
    fresh_start = False
    def start(self):
        if self.mapname=="outside_temple2.map":
            change_music(filename="final.it",vol=1.0)
        elif self.mapname.startswith("wmap"):
            change_music(filename="world.it", vol=0.4)
        elif self.mapname.startswith("dmap"):
            change_music(filename="dungeon.it", vol=0.4)
        elif self.mapname=="temple.map":
            if soundOn:
                if not pygame.mixer.music.get_busy():
                    change_music(filename="final.it", vol=1.0)
        else:
            change_music()


        ui_world.__init__(player)
        self.capture() #start eventnet for this object
        self.done = False
        self.mode = 0
        player.gen_itemlist()

        self.vel = [0,0]
        self.left_pressed = False
        self.right_pressed = False
        self.up_pressed = False
        self.down_pressed = False
        self.enter_pressed = False

        self.map = load_map(self.mapname)
        self.map["pad"] = (48, 32)  #padding of maparea on screen
        self.map["off"] = [0,0]
        self.map["view"] = (704, 352)
        self.map["rect"] = pygame.Rect((0,0), self.map["view"])
        self.mapimg = MapImg(self.map)

        self.chara = MapChara()

        cx, cy = self.startpos
        self.chara.set_coord(cx, cy)
        self.map["off"] = [cx, cy]
        self.map["rect"] = pygame.Rect((cx*32-352,cy*32-160), self.map["view"])

        self.rnd_encounter = 0

        cx, cy = self.map["view"]
        cx, cy = cx/2/32, cy/2/32
        self.chara.place(cx*32 + self.map["pad"][0], cy*32+self.map["pad"][1])
        self.chara.center = (cx, cy)
        self.sprites = pygame.sprite.RenderUpdates()
        self.sprites.add(self.chara)

        self.screen = pygame.display.get_surface()
        self.screen.fill((10,0,0))

        if self.fresh_start:
            self.chara.set_moving([1,0])  #look right
            self.EVT_tick()
            ui_world.activate(4, "introdude")  #intro NPC-talk
            WorldMap.fresh_start = False
            self.mode = 4
        if self.mapname=="outside_temple2.map":
            self.chara.set_moving([0,-1])  #look up
            self.EVT_tick()
            ui_world.activate(4, "whathappen")
            self.mode = 4

    def EVT_tick(self, event=None):
        if self.mode==0:  #walking on worldmap
            self.walk()
            self.screen.fill(self.bg)
            self.screen.blit(ui_world,(0,0))
            self.screen.blit(self.mapimg, self.map["pad"], self.map["rect"])
            self.sprites.update()
            self.sprites.draw(self.screen)

        elif self.mode==1:  #inventory
            if self.update_ui():
                ui_world.redraw(1)
                self.screen.blit(ui_world,(0,0))
            elif ui_world.uiparts[1][0].exit:
                self.mode = 0
                ui_world.deactivate(1)

        elif self.mode==2:  #battle
            self.update_ui()
            if ui_world.turn():
                player.gen_itemlist()
                self.mode = 0
                dead = 0
                for p in player.party:  #how many dead?
                    if p.cond[0]:
                        dead += 1
                if dead==len(player.party): # all dead?
                    self.quit(next=GameOver())
                elif player.you_win:
                    self.quit(next=Outro())
                elif player.find_item("Magical String") \
                    and not player.stringy_shown:
                    mapevents["wmap1.map"][8]=([25,15],3,"outside_temple2.map",[24,33])
                    self.EVT_tick()
                    ui_world.activate(4, "stringy")
                    player.stringy_shown = True
                    self.mode = 4

            ui_world.update()
            if ui_world.update_gfx:
                self.screen.blit(ui_world,(0,0))
                pygame.display.flip()
                return

        elif self.mode==3:  #city shopping
            if self.update_ui():
                ui_world.redraw(3)
                self.screen.blit(ui_world,(0,0))
            elif ui_world.uiparts[3][0].exit:
                ui_world.deactivate(3)
                player.gen_itemlist()
                self.mode = 0

        elif self.mode==4:  #dialog
            if self.update_ui() or ui_world.update_gfx:
                ui_world.redraw()
                ui_world.update_gfx = False
                self.screen.blit(ui_world, (0,0))
                pygame.display.flip()
            elif ui_world.uiparts[4][0].exit:
                if ui_world.uiparts[4][0].name=="whathappen":
                    ui_world.deactivate(4)
                    self.mode = 0
                    self.EVT_tick()
                    self.mode = 5
                    self.up_pressed = True
                else:
                    ui_world.deactivate(4)
                    self.mode = 0
            return
        elif self.mode==5: # outsidetemple2 script
            if self.chara.coord[1] <= 31:
                self.up_pressed = False
                self.chara.set_moving([-1,0])
                self.mode = 0
                self.EVT_tick()
                ui_world.activate(4, "deaddude")
                self.mode = 4
            else:
                self.walk()
                self.screen.fill(self.bg)
                self.screen.blit(ui_world,(0,0))
                self.screen.blit(self.mapimg, self.map["pad"], self.map["rect"])
                self.sprites.update()
                self.sprites.draw(self.screen)
        elif self.mode==6:
            if self.update_ui():
                ui_world.redraw(5)
                self.screen.blit(ui_world,(0,0))
            elif ui_world.uiparts[5][0].exit:
                self.mode = 0
                ui_world.deactivate(5)
        pygame.display.flip()

    def update_ui(self):
        bol = True
        if self.up_pressed:
            ui_world.keypress(0)
        elif self.down_pressed:
            ui_world.keypress(1)
        elif self.enter_pressed:
            self.enter_pressed = False
        else:
            bol = False
        #if bol and not self.mode==4:
            #dc_sfx["sel"].play()
        self.scrolling = bol
        return bol

    def walk(self):
        vel = (0,0)
        speed = 2
        top, left = self.map["rect"].top, self.map["rect"].left
        moving = self.vel[0] or self.vel[1]
        if self.up_pressed and not moving:
            vel = (0, -speed)
        elif self.down_pressed and not moving:
            vel = (0, speed)
        elif self.left_pressed and not moving:
            vel = (-speed, 0)
        elif self.right_pressed and not moving:
            vel = (speed, 0)
        elif top%32 or left%32:
            self.chara.stop()
            vel = self.vel

        if self.check_blocking(vel[0]/speed, vel[1]/speed):
            self.chara.set_moving(vel)
            vel = (0,0)

        self.scroll_map(vel)

    def check_blocking(self, vx, vy):
        tx, ty = self.chara.coord
        tx, ty = tx+vx, ty+vy
        if not self.map["name"].startswith("outside"):
            return self.map[tx,ty][1]
        else:
            self.check_mapevent(coord=(tx,ty))
            return self.map[tx,ty][1]

    def EVT_KeyDown(self, event):
        if self.mode==5:
            return
        k = event.key
        if k==K_F12 and self.mode==0:
            self.save_game()
        elif k==K_UP:
            self.up_pressed = True
        elif k==K_DOWN:
            self.down_pressed = True
        elif k==K_LEFT:
            self.left_pressed = True
        elif k==K_RIGHT:
            self.right_pressed = True

    def EVT_KeyUp(self, event):
        if self.mode==5:
            return
        k = event.key
        if k==K_UP:
            self.up_pressed = False
        elif k==K_DOWN:
            self.down_pressed = False
        elif k==K_LEFT:
            self.left_pressed = False
        elif k==K_RIGHT:
            self.right_pressed = False
        elif k==K_i and self.mode==0 and not self.chara.moving:
            self.mode = 1
            ui_world.activate(1)
            self.screen.blit(ui_world,(0,0))
        elif k==K_i and self.mode==1:
            self.mode = 0
            ui_world.deactivate(1)
        elif k==K_s and self.mode==0:
            self.mode = 6
            ui_world.activate(5)
            self.screen.blit(ui_world, (0,0))
        elif k==K_s and self.mode==6:
            self.mode = 0
            ui_world.deactivate(5)
        elif k==K_RETURN and self.mode==0 and not self.chara.moving:
            self.enter_city()
        elif k==K_RETURN and self.mode>0:
            ui_world.submit(1)
            self.enter_pressed = True
        elif k==K_ESCAPE and self.mode>0:
            ui_world.submit(0)
            self.enter_pressed = True
        elif k==K_ESCAPE and self.mode==0:
            self.quit(next=StartMenu())
        elif k==K_TAB and self.mode==0:
            if self.chara.animlist is mchar:
                self.chara.set_animlist(mchar2)
            elif self.chara.animlist is mchar2:
                self.chara.set_animlist(mchar3)
            elif self.chara.animlist is mchar3:
                self.chara.set_animlist(mchar)
            self.sprites.draw(self.screen)
            pygame.display.update()

    def scroll_map(self, vel):
        vx, vy = vel[0], vel[1]
        l = self.map["rect"].left + vx
        t = self.map["rect"].top + vy
        rect = self.mapimg.get_rect()
        if vx: #move horizontally
            if l>=0 and l<=rect.width-self.map["view"][0]:
                self.map["off"][0] += vx
                self.map["rect"].left = l
                self.vel = [vx, vy]
                if not t%32 and not l%32:
                    self.chara.change_coord(self.vel)
                    self.check_mapevent()

        elif vy: #move vertically
            if t>=0 and t<=rect.height-self.map["view"][1]:
                self.map["off"][1] += vy
                self.map["rect"].top = t
                self.vel = [vx, vy]
                if not t%32 and not l%32:
                    self.chara.change_coord(self.vel)
                    self.check_mapevent()
        else:
            self.vel = (0,0)
        self.chara.set_moving(self.vel)


    def enter_city(self):
        """
        Enter shopping screen or talk to npc
        """
        f = self.chara.facing
        cx, cy = self.chara.coord
        if f==0:  #down
            cy += 1
        elif f==1:  #up
            cy -= 1
        elif f== 2:  #left
            cx -= 1
        elif f==3:  #right
            cx += 1

        for ev in mapevents[self.mapname]:
            if self.chara.coord==ev[0] and ev[1]==2:
                name=None
                if len(ev)>2:
                    name=ev[2]
                ui_world.activate(3, name)
                self.mode = 3
                self.screen.blit(ui_world,(0,0))
            elif [cx,cy]==ev[0] and ev[1]==4:  #chara looks toward npc?
                face = self.chara.facing
                nface = 2  #right

                if face==0: #down
                    nface = 1
                elif face==1:  #up
                    nface = 0
                elif face==2:  #left
                    nface = 3

                self.mapimg.draw_npc([cx, cy], ev[2], nface)
                self.EVT_tick(None)
                ui_world.activate(4, ev[2])  #NOTE: ev[2] is npc name
                self.mode = 4


    def check_mapevent(self, keypress=None, coord=None):
        if not player.tick():
            self.quit(next=GameOver())
        if not coord:
            coord = self.chara.coord

        ui_world.update()
        self.rnd_encounter += 3
        encount = 1
        for ev in mapevents[self.mapname]:
            if coord==ev[0]:
                encount = 0
                if ev[1]==1:  #encounter
                    self.load_encounter([ev[2]])
                    mapevents[self.mapname].remove(ev)
                    if ev[2]=="Chest":
                        self.mapimg.draw_special(ev[0], img_chest_o)
                    elif ev[2]=="Shadow Legion Chest":
                        self.mapimg.draw_special(ev[0], img_bosschest_o)
                    elif ev[2]=="Mercator" or ev[2]=="Brugoth" or\
                         ev[2]=="Xekolth" or ev[2]=="Felimon":
                        self.mapimg.draw_special(ev[0])
                    else:
                        self.mapimg.draw_special(ev[0])
                    self.rnd_encounter = 0
                elif ev[1]==2:
                    pass
                elif ev[1]==3:  #portal to Rising Sun Temple
                    if ev[2]=="outside_temple.map":
                        if player.find_item("Magical String"):
                            self.rnd_encounter = 0
                            self.goto_map("outside_temple2.map", ev[3])
                            return
                    self.rnd_encounter = 0
                    self.goto_map(ev[2], ev[3])

        if encount and not self.map["name"].startswith("outside"):
            if random.randrange(0,rnd_encprob) < self.rnd_encounter:
                self.rnd_encounter = 0
                str_nr = player.count_item()

                if player.find_item("Magical String"):
                    mlist = mapmonsters["4"]
                else:
                    if self.map["name"].startswith("wmap1"):
                        name = "e"
                        mlist = mapmonsters[str(str_nr)+name]
                    elif self.map["name"].startswith("wmap"):
                        name = "m"
                        mlist = mapmonsters[str(str_nr)+name]
                    else:
                        name = "h"
                        mlist = mapmonsters[str(str_nr)+name]
                enc = []
                for i in range(random.randrange(1,5)):
                    nr = random.randrange(0, len(mlist))
                    enc.append(mlist[nr])
                self.load_encounter(enc)

    def goto_map(self, name, pos):
        WorldMap.mapname = name
        WorldMap.startpos = pos
        self.quit(next=WorldMap())

    def load_encounter(self, opt):
        if self.map["tileset"]=="dungeon.png":
            opts = [opt, battle_bg2]
        else:
            opts = [opt, battle_bg1]
        ui_world.update()
        ui_world.activate(2, opts)
        self.mode=2

    def exit(self):
        eventnet.driver.post("Quit")

    def save_game(self):
        dat = {}
        dat["player"] = player.gather_data()
        dat["mapevents"] = mapevents
        dat["charpos"] = self.chara.coord
        dat["mapname"] = self.mapname

        try:
            f = open("savegame.dat", "w")
            pickle.dump(dat, f)
            f.close()
            print "Saved."
        except:
            print "Could not save game, sorry.. very sorry.. >.<"

class GameOver(State):
    def start(self):
        change_music("gameover.ogg", 0)
        self.capture() #start eventnet for this object
        self.done = False

        self.screen = pygame.display.get_surface()
        self.screen.fill((0,0,0))

        self.msg = data.load_image("gameover.png")
        self.screen.blit(self.msg, (0,0))
        pygame.display.flip()

    def EVT_MouseButtonDown(self, event):
        self.quit(next=StartMenu())

    def EVT_tick(self, event):
        pass

    def EVT_KeyUp(self, event):
        if event.key==K_ESCAPE:
            self.quit(next=StartMenu())


class StartMenu(State):
    def start(self):
        self.capture() #start eventnet for this object
        self.done = False

        change_music("intro.it")
        options =  ["Continue", "New Game", "Quit"]
        self.bbox = ButtonBox(opts=options, pad=(23,4))
        sx, sy = self.bbox.get_size()
        self.center = ((800-sx)/2, 400)
        self.bbox.activate()

        self.opts = [pygame.Rect((145,367),(143,189)), pygame.Rect((525,367),(143,189))]

        self.activebox = self.bbox
        self.screen = pygame.display.get_surface()
        img = data.load_image("titlescreen.png")
        self.screen.blit(img, (0,0))

    def boxcheck(self):
        nr = self.activebox.selected
        if nr==0:
            fresh_start = False
            self.load_game()
        elif nr==1:
            self.start_game()
        elif nr==2:
            self.exit()

    def EVT_MouseButtonDown(self, event):
        for o in self.opts:
            if o.collidepoint(pygame.mouse.get_pos()):
                self.quit(next=Credits())

    def EVT_KeyDown(self, event):
        k = event.key
        if k==K_F12:
            self.exit()
        elif k==K_DOWN:
            self.activebox.go(1)
        elif k==K_UP:
            self.activebox.go(-1)
        elif k==K_RETURN:
            self.boxcheck()

    def EVT_tick(self, event):
        self.screen.blit(self.bbox, self.center)
        pygame.display.flip()

    def exit(self):
        eventnet.driver.post("Quit")

    def start_game(self):
        for k in mapevents.keys():
            mapevents[k] = event_backup[k]
        WorldMap.fresh_start = True
        WorldMap.mapname = "wmap1.map"
        WorldMap.startpos = [25,16]
        player.__init__()
        self.quit(next=Intro())

    def load_game(self):
        try:
            f = open("savegame.dat", "r")
            dat = pickle.load(f)
            WorldMap.mapname=dat["mapname"]
            WorldMap.startpos=dat["charpos"]

            player.load_data(dat["player"])

            for k in mapevents.keys():
                mapevents[k] = dat["mapevents"][k]

            print "Loaded."
            WorldMap.fresh_start = False
            self.quit(next=WorldMap())
        except:
            print "Could not load game. So.. sorry... X.X"


class Credits(State):
    def start(self):
        self.capture() #start eventnet for this object
        self.done = False

        self.opts = [pygame.Rect((145,367),(143,189)), pygame.Rect((525,367),(143,189))]
        msg = data.load_image("credits.png")
        self.screen = pygame.display.get_surface()
        self.screen.blit(msg, (0,0))
        pygame.display.flip()

    def EVT_MouseButtonDown(self, event):
        self.quit(next=StartMenu())


    def EVT_KeyUp(self, event):
        if event.key == K_ESCAPE:
            self.quit(next=StartMenu())

class Intro(State):
    def start(self):
        self.capture() #start eventnet for this object
        self.done = False

        self.images = [
            data.load_image("intro/intro1.png"),
            data.load_image("intro/intro1_1.png"),
            data.load_image("intro/intro1_2.png"),
            data.load_image("intro/intro1_3.png"),
            data.load_image("intro/intro1_4.png"),

            data.load_image("intro/intro1_5.png"),
            data.load_image("intro/intro1_6.png"),
            data.load_image("intro/intro1_7.png"),
            data.load_image("intro/intro1_8.png"),
            data.load_image("intro/intro1_9.png"),

            data.load_image("intro/intro2.png"),
            data.load_image("intro/intro2_1.png"),
            data.load_image("intro/intro2_2.png"),
            data.load_image("intro/intro2_3.png"),
            data.load_image("intro/intro2_4.png")
            ]

        self.art = [
            data.load_image("intro/01.jpg"),
            data.load_image("intro/02.jpg"),
            data.load_image("intro/03.jpg"),
            data.load_image("intro/04.jpg"),
            data.load_image("intro/05.jpg"),
            data.load_image("intro/06.jpg"),
            data.load_image("intro/07.jpg"),
            data.load_image("intro/08.jpg"),
            data.load_image("intro/09.jpg"),
            data.load_image("intro/10.jpg")
        ]

        self.tick = 0
        self.delay = 50
        self.fading =False
        self.step = -1
        self.img = self.images.pop(0)
        self.img.set_alpha(0)
        self.tmp = 0
        self.textpos = (50,400)

        f=data.load("intro.txt","r")
        self.lines = []
        page = []
        for line in f:
            if line.strip()=="":
                self.lines.append(page)
                page = []
            else:
                page.extend(gen_lines(line.strip(), 75))
                page.append("")
        f.close()

        self.page = 0

        msg = gen_lines("Miau!", 75)
        self.textbox = TextBox(msg, (700,155), pad=(10,10))
        self.screen = pygame.display.get_surface()
        self.press_space=sfont.render("Press <space>",1,(255,255,255),(0,0,0))

        self.next_page()



    def EVT_tick(self, event):
        busy = False
        if soundOn:
            busy = pygame.mixer.music.get_busy()
        if self.fading and not busy:
            self.next_page()
            self.page = 0
            self.fading = 0
        if not self.page:
            self.tick += 1
            if self.check():
                self.screen.blit(self.img, (57, 20))
                pygame.display.flip()

    def fadein(self):
        self.tmp += 3
        self.img.set_alpha(self.tmp)

    def check(self):
        if self.step==-1:
            pass

        if self.step==0 and self.tick < self.delay:
            self.fadein()
            return True
        elif self.step==0:
            return self.set_next(10)

        elif self.step==1 and self.tick >= self.delay:
            return self.set_next(10)
        elif self.step==2 and self.tick >= self.delay:
            return self.set_next(5)
        elif self.step==3 and self.tick >= self.delay:
            return self.set_next(5)
        elif self.step==4 and self.tick >= self.delay:
            return self.set_next(5)
        elif self.step==5 and self.tick >= self.delay:
            return self.set_next(5)

        elif self.step==6 and self.tick >= self.delay:
            return self.set_next(50)
        elif self.step==7 and self.tick >= self.delay:
            return self.set_next(30)
        elif self.step==8 and self.tick >= self.delay:
            return self.set_next(30)
        elif self.step==9 and self.tick >= self.delay:
            return self.set_next(20)
        elif self.step==10 and self.tick >= self.delay:
            return self.set_next(30)

        elif self.step==11 and self.tick >= self.delay:
            return self.set_next(50)
        elif self.step==12 and self.tick >= self.delay:
            return self.set_next(50)
        elif self.step==13 and self.tick >= self.delay:
            return self.set_next(50)

        elif self.step==14 and self.tick >= self.delay:
            self.step = 15
            self.page = 20
            self.next_page()
        return False

    def set_next(self, delay):
        self.step += 1
        self.tick = 0
        self.delay = delay
        self.img = self.images.pop(0)
        return True

    def next_page(self):
        if self.lines and self.step<1:
            self.screen.fill((0,0,0))
            self.screen.blit(self.art[self.page], (57, 20))
            self.textbox.change_lines(self.lines.pop(0))
            self.screen.blit(self.textbox, self.textpos)
            self.screen.blit(self.press_space, (330, 580))
            self.page += 1
            pygame.display.flip()
        elif self.page==10 and not self.fading:
            change_music()
            self.fading = True
        elif self.step==15:
            self.start_game()
        else:
            self.screen.fill((0,0,0))
            self.page = 0
            self.tick = 0
            self.step = 0

    def start_game(self):
        change_music()
        WorldMap.mapname = "outside_temple.map"
        WorldMap.startpos = [23,31]
        self.quit(next=WorldMap())

    def EVT_KeyUp(self, event):
        k = event.key
        if k==K_ESCAPE:
            self.start_game()
        elif k==K_SPACE and self.page:
            self.next_page()

class Outro(State):
    def start(self):
        change_music(filename="outro.it")
        self.capture() #start eventnet for this object
        self.done = False

        self.tick = 0
        self.delay = 3
        self.fade = False
        self.alpha = 250
        self.img = data.load_image("outro/outro.png")
        self.screen = pygame.display.get_surface()
        self.draw_img()

        f=data.load("outro.txt","r")
        self.lines = []
        page = []
        for line in f:
            if line.strip()=="":
                self.lines.append(page)
                page = []
            else:
                page.extend(gen_lines(line.strip(), 75))
                page.append("")
        f.close()
        self.page = 0
        self.textpos = (50,400)
        msg = gen_lines("Miau!", 75)
        self.textbox = TextBox(msg, (700,155), pad=(10,10))
        self.press_space=sfont.render("Press <space>",1,(255,255,255),(0,0,0))
        self.next_page()

    def next_page(self):
        if self.lines:
            self.textbox.change_lines(self.lines.pop(0))
            self.screen.blit(self.textbox, self.textpos)
            self.screen.blit(self.press_space, (330, 580))
            self.page += 1
            pygame.display.flip()

    def EVT_tick(self, event):
        if self.fade:
            self.tick += 1
            if self.fadeout():
                self.draw_img()
                if self.alpha < -100:
                    self.to_credits()


    def fadeout(self):
        if self.tick > self.delay:
            self.alpha -= 8
            self.img.set_alpha(self.alpha)
            self.tick = 0
            return True
        return False

    def EVT_KeyUp(self, event):
        k = event.key
        if k==K_SPACE:
            if self.lines:
                self.next_page()
            else:
                self.fade = True
                if soundOn:
                    pygame.mixer.music.fadeout(1500)
        elif k==K_ESCAPE:
            self.to_menu()

    def draw_img(self):
        self.screen.fill((0,0,0))
        self.screen.blit(self.img, (57,20))
        pygame.display.flip()

    def to_menu(self):
        self.quit(next=StartMenu())

    def to_credits(self):
        change_music(filename="credits.it")
        self.quit(next=Credits())
