import data, pygame, random
from directicus.sprite import *

import formulas

from stuff import *
from items import *
from spells import spell, circle
from battle import FightEntity


class MapChara(Sprite):
    animlist = mchar
    anim = mchar[0]
    image = mchar[0][0]
    vel = None
    offcenter = [0,0]
    off=16
    center = (0,0)
    coord = [0,0]
    moving = False
    tick = 0
    charanr = 0
    facing = 0
    index = 0

    def start(self):
        self.anim = self.animlist[self.facing]


    def set_animlist(self, animlist):
        i = self.animlist.index(self.anim)
        self.animlist = animlist
        self.anim = self.animlist[i]
        self.image = self.anim[self.index]

    def change_coord(self, (vx, vy)):
        if vx > 0:
            self.coord[0] += 1
        elif vx < 0:
            self.coord[0] -= 1
        elif vy > 0:
            self.coord[1] += 1
        elif vy < 0:
            self.coord[1] -= 1

    def set_coord(self, x, y):
        self.coord = [x, y]

    def place(self, x, y):
        """ physical placement of sprite """
        self.rect.top = y
        self.rect.left = x

    def update(self):
        if self.moving or self.index%2:
            self.tick += 1
            if self.tick > 7:
                self.index += 1
                if self.index > 3:
                    self.index = 0
                self.image = self.anim[self.index]
                self.tick = 0

    def stop(self):
        self.moving = False

    def set_moving(self, (vx, vy)):
        self.moving = True
        nr = None
        if vx > 0:  #right
            nr = 3
        elif vx < 0: #left
            nr = 2
        elif vy > 0:  #down
            nr = 0
        elif vy < 0:  #up
            nr = 1
        else:
            self.moving = False

        if nr is not None and self.anim!=self.animlist[nr]:
            self.anim = self.animlist[nr]
            self.image = self.anim[0]
            self.facing = nr


class Chara (FightEntity):
    def __init__(self, name="Rafael"):
        FightEntity.__init__(self)
        self.name = name
        self.monster = 0
        self.ep_max = 100 * self.level
        self.attr = formulas.calc_attr(self.siav)
        self.cur_attr = formulas.calc_attr(self.cur_siav)

        self.lvl = 1
        self.circle = 1
        self.circlemult = 1
        if name=="Rafael":
            self.alive_image = mchar[3][0].copy()
            self.dead_image = data.load_image("battle/chara1.png", True)
            self.siav = [5,40,15,10]
            self.siav_bonus = [1,4,2,1]
            self.circlemult = 3
        elif name=="Sonea":
            self.alive_image = mchar2[3][0].copy()
            self.dead_image = data.load_image("battle/chara2.png", True)
            self.siav = [20,20,20,20]
            self.siav_bonus = [2,2,2,2]
            self.circlemult = 5
        else:
            self.alive_image = mchar3[3][0].copy()
            self.dead_image = data.load_image("battle/chara3.png", True)
            self.siav = [30,5,20,25]
            self.siav_bonus = [3,0,2,3]
            self.circlemult = 7

        self.attr = formulas.calc_attr(self.siav)
        self.cur_siav = self.siav[:]
        self.cur_attr = formulas.calc_attr(self.siav)
        self.image = self.alive_image
        self.spells = circle[self.circle-1]["spells"]  #give every chara level 1 spells
        self.gen_spellbook()

    def gen_contextlist(self, type):
        lines = []
        if type==useable or type==quest_item:  #list attributes
            p = self
            hp, mp = str(self.cur_attr[0]), str(self.cur_attr[1])
            mhp, mmp =  str(self.attr[0]), str(self.attr[1])
            s, i = str(self.cur_siav[0]), str(self.cur_siav[1])
            a, v = str(self.cur_siav[2]), str(self.cur_siav[3])

            line1 = " "+self.name+" - "+"HP:"+hp+"/"+mhp + " MP:" +mp+"/"+mmp
            line2 = "STR:"+s+" "+"INT:"+i+" "+"AGI:"+a+" "+"VIT:"+v
            lines = [line1, line2]
        return lines

    def set_action(self, action):
        self.action = action

    def add_spell(self, name):
        if spell.has_key(name):
            self.spells.append(name)

    def death_anim(self):
        if not self.died:
            self.image = self.dead_image
            self.surf.blit(self.bg, self.pos)
            self.surf.blit(self.image, self.pos)
            dc_sfx["pdeath"].play()

    def res_anim(self):
        self.image = self.alive_image
        self.surf.blit(self.bg, self.pos)
        self.surf.blit(self.image, self.pos)
        dc_sfx["revive"].play()

    def gen_spellbook(self):
        self.spells = []
        for i in xrange(self.circle):
            self.spells.extend(circle[i]["spells"])

        self.spellbook = []
        for i in xrange(9):
            self.spellbook.append([])
        for s in self.spells:
            if spell.has_key(s):
                self.spellbook[spell[s]["circle"]-1].append(s)

class Player:
    def __init__(self):
        self.party = [Chara()]
        self.stringy_shown = False
        self.inv = []
        self.gold = 0
        self.add_member(Chara(name="Sonea"))
        self.add_member(Chara(name="Athon"))
        self.add_gold(100)
        self.add_item("Map", 1)
        self.add_item("Piece of Magical String", 1) # need at least 1 item in inventory!!
        self.add_item("Small Health Potion", 6)
        self.add_item("Small Mana Potion", 6)
        self.add_item("Divine Charm", 3)
        self.you_win = False

    def count_item(self, name="Piece of Magical String"):
        nr = self.find_item(name)
        if nr is not None:
            return self.inv[nr][1]
        return None

    def add_member(self, chara):
        self.party.append(chara)

    def add_item(self, name, nr=1):
        if item.has_key(name):
            added = False
            if name=="Piece of Magical String" and \
               self.count_item("Piece of Magical String")>=3:
                self.inv[1] = ["Magical String", 1]
                return

            for i in self.inv:
                if i[0]==name:
                    i[1]+=nr
                    if i[1]>99:
                        i[1]=99
                    added = True
                    break
            if not added:
                if nr>99:
                    nr=99
                self.inv.append([name, nr])
        self.gen_itemlist()

    def buy_item(self, name, howmany=1):
        if item.has_key(name):
            if item[name].has_key("price"):
                price = item[name]["price"]
            else:
                price = 1
            if self.add_gold(-price):
                self.add_item(name)
                return True
        return False

    def gen_itemlist(self, type=None):
        itemlist = []
        for i in self.inv:
            if i[1] < 10:
                nr = " (" + str(i[1]) +") "
            else:
                nr = "(" + str(i[1]) +") "
            if (type == None) or (item[i[0]]["type"]==type):
                itemlist.append(nr + i[0])
        return itemlist

    def use_item(self, charnr, itemnr):
        i = item[self.inv[itemnr][0]]
        if self.rem_item(itemnr):
            self.party[charnr].apply_item(i)
            return True
        return False

    def rem_item(self, nr, howmany=1):
        if nr > len(self.inv):
            return False
        elif item[self.inv[nr][0]]["type"]==0 or howmany > self.inv[nr][1]:
            return False  #do not remove quest items or more than available
        elif howmany==self.inv[nr][1]:
            self.inv.pop(nr)
        else:
            self.inv[nr][1] -= 1
        self.gen_itemlist()
        return True

    def sell_item(self, nr, name, howmany=1):
        if self.rem_item(nr, howmany):
            if item[name].has_key("price"):
                price = item[name]["price"]
                if price > 1:
                    self.add_gold(price/2*howmany)
                else:
                    self.add_gold(1*howmany)
            else:
                self.add_gold(1*howmany)
            return True
        return False

    def finduseitem(self, name, charnr):
        itemnr = self.find_item(name)
        if itemnr is not None:
            self.use_item(charnr, itemnr)

    def findsell(self, name, howmany=1):
        itemnr = self.find_item(name)
        if itemnr is not None:
            if self.sell_item(itemnr, name, howmany):
                return True
        return False

    def find_item(self, name):
        for i in self.inv:
            if i[0] == name:
                return self.inv.index(i)
        return None

    def add_gold(self, gold):
        if self.gold + gold > 999999:
            self.gold = 999999
            return True
        elif self.gold + gold < 0:
            return False
        else:
            self.gold += gold
            return True

    def add_ep(self, ep):
        divide = 0
        for p in self.party:
            if not p.cond[0]:
                divide += 1
        if divide:
            points = ep/divide
            new_circle = []
            for p in self.party:
                if not p.cond[0]:
                    if p.add_ep(points):  #levelup and new circle!
                        new_circle.append(p.name)
            return new_circle


    def run(self, enc):
        # do not run from bossmonster or chest!!
        return formulas.calc_run(self.party, enc)


    def tick(self):
        alive = 0
        for c in self.party:
            c.tick()
            if not c.cond[0]:
                alive +=1

        return alive

    def gather_data(self):
        def get_chardata(chara):
            cdict = {}
            cdict["name"] = chara.name
            cdict["level"] = chara.level
            cdict["ep"] = chara.ep
            cdict["ep_max"] = chara.ep_max
            cdict["siav"] = chara.siav
            cdict["cur_siav"] = chara.cur_siav
            cdict["attr"] = chara.attr
            cdict["cur_attr"] = chara.cur_attr
            cdict["cond"] = chara.cond
            cdict["effects"] = chara.effects
            cdict["effect_sum"] = chara.effect_sum
            cdict["spells"] = chara.spells
            cdict["circlemult"] = chara.circlemult
            cdict["circle"] = chara.circle
            return cdict

        pdict = {}
        pdict["gold"] = self.gold
        pdict["stringy_shown"] = self.stringy_shown
        pdict["inv"] = self.inv

        party = []
        for c in self.party:
            party.append(get_chardata(c))
        pdict["party"] = party
        return pdict


    def load_data(self, dat):
        def set_chardata(chara, c):
            chara.name = c["name"]
            chara.level = c["level"]
            chara.ep = c["ep"]
            chara.ep_max = c["ep_max"]
            chara.siav = c["siav"]
            chara.cur_siav = c["cur_siav"]
            chara.attr = c["attr"]
            chara.cur_attr = c["cur_attr"]
            chara.cond = c["cond"]
            chara.effects = c["effects"]
            chara.effect_sum = c["effect_sum"]
            chara.spells = c["spells"]
            chara.circlemult = c["circlemult"]
            chara.circle = c["circle"]

        self.gold = dat["gold"]
        self.inv = []
        self.stringy_shown = dat["stringy_shown"]
        for i in dat["inv"]:
            self.add_item(i[0], i[1])

        x = 0
        for d in dat["party"]:
            set_chardata(self.party[x], d)
            x+=1


#just testing!
        #self.add_item("Magical String")
        #self.party[0].circle = 8
#just testing!


