import eventnet, data, pygame
from pygame.locals import *
from directicus.engine import State
from directicus.gfx import *
from map import *


class Editor(State):
    mapname="katze.map"
    mgen=(100,30)
    mtileset="dungeon.png"

    def start(self):
        self.capture() #start eventnet for this object
        self.done = False

        self.tile_type = None
        self.typebar = []

        self.map = load_map(self.mapname)
        if not self.map:
            self.map = gen_map(self.mgen, self.mtileset, self.mapname)
        self.tileset=data.load_tileset(self.map["tileset"])

        self.off = [0,0]
        self.mapimg = MapImg(self.map)
        self.maprect = pygame.Rect((0,0), (800,384))

        self.screen = pygame.display.get_surface()
        self.screen.fill((10,10,10))
        self.display_tileset()

    def EVT_tick(self,event):
        self.check_mouse()
        self.screen.blit(self.mapimg,(0,0), self.maprect)
        pygame.display.flip()

    def EVT_MouseButtonDown(self, event):
        pos = pygame.mouse.get_pos()
        if not self.set_tile():
            for type in self.typebar:
                if type[1].collidepoint(pos):
                    if self.tile_type:
                        self.highlight(self.tile_type[1], (0,0,0))
                    self.tile_type = type
                    self.highlight(type[1], (250,250,250))
                    break

    def set_tile(self):
        pos = pygame.mouse.get_pos()
        if pos[1]<384 and self.tile_type:
            x, y = pos[0]/32, pos[1]/32
            x, y = (x+self.off[0]), (y+self.off[1])
            print x, y
            self.map[x, y] = [self.tile_type[0], 0]
            self.mapimg.map = self.map
            self.mapimg.blit(self.tile_type[2], (x*32,y*32))
            ox, oy = self.off
            self.mapimg.overlap((ox, oy, ox+26, oy+13))
            return 1
        return 0

    def EVT_KeyDown(self, event):
        k = event.key
        if k==K_ESCAPE:
            self.exit()
        elif k==K_RIGHT:
            self.scroll_map(1, 0)
        elif k==K_LEFT:
            self.scroll_map(-1, 0)
        elif k==K_UP:
            self.scroll_map(0, -1)
        elif k==K_DOWN:
            self.scroll_map(0, 1)
        elif k==K_s:
            save_map(self.mapname, self.map)


    def scroll_map(self, vx, vy):
        l = self.maprect.left + (32*vx)
        t = self.maprect.top + (32*vy)
        r = self.mapimg.get_rect()
        if vx and l>=0 and l<r.width-786:
            self.off[0] += vx
            self.maprect.left = l
        elif vy and t>=0 and t<r.height-352:
            self.off[1] += vy
            self.maprect.top = t

    def check_mouse(self):
        if pygame.mouse.get_pressed()[0]:
            self.set_tile()

    def display_tileset(self):
        y = 400
        offset = 33
        j = 0
        for line in self.tileset:
            x = 10
            i = 0
            for tile in line:
                self.screen.blit(tile, (x,y))
                self.typebar.append([(j, i), pygame.Rect(x,y,32,32), tile])
                x += offset
                i += 1
            y += offset
            j += 1

    def highlight(self, rect, color):
        t = rect.top - 1
        l = rect.left - 1
        w = rect.width + 1
        h = rect.height + 1
        r = pygame.Rect(l, t, w, h)
        pygame.draw.rect(self.screen, color, r, 1)

    def exit(self):
        eventnet.driver.post("Quit")
