'''Simple data loader module.

Loads data files from the "data" directory shipped with a game.

Enhancing this to handle caching etc. is left as an exercise for the reader.
'''

import os, pygame
from directicus.gfx import *

data_py = os.path.abspath(os.path.dirname(__file__))
data_dir = os.path.normpath(os.path.join(data_py, '..', 'data'))


def filepath(filename):
    '''Determine the path to a file in the data directory.
    '''
    return os.path.join(data_dir, filename)

def load(filename, mode='rb'):
    '''Open a file in the data directory.

    "mode" is passed as the second arg to open().
    '''
    return open(os.path.join(data_dir, filename), mode)

def load_tileset(filename):
    return loadGrid(pygame.image.load(filepath("gfx/"+filename)), (32,32))

def load_image(filename, colorkey=None):
    img = pygame.image.load(filepath("gfx/"+filename))
    if colorkey:
        img.set_colorkey(img.get_at((0,0)))
    return img

def load_chara(filename):
    return loadGrid(pygame.image.load(filepath("gfx/"+filename)), (32,32))

def load_anim(imglist):
    return Animation(seq=imglist)

def load_sound(filename):
    sfx = pygame.mixer.Sound(filepath("sfx/"+filename))
    sfx.set_volume(0.5)
    return sfx
