import data, pygame, random
from directicus.sprite import *

import formulas
from stuff import *
from spells import spell, circle
from monsters import *


class FightEntity:
    def __init__(self):
        self.name=""
        self.died = False
        self.monster = 1
        self.cond = [0,0,0,0,0,0,0,0]
        self.kills = 0
        self.level = 1
        self.ep = 0
        self.ep_max = 100
        self.action = []
        self.siav = [2,2,2,2]
        self.cur_siav = self.siav[:]
        self.effects = []

        #sum of boni/mali on siav, attr and cond
        self.effect_sum=[[0,0,0,0], [0,0,0,0,0,0,0,0]]

        self.attr = formulas.calc_attr(self.siav)
        self.cur_attr = formulas.calc_attr(self.siav)

        self.image = unknown_monster.copy()
        self.pos=(0,0)
        self.circlemult = 1

        self.circle = 0
        self.circles = []
        self.spells = []

    def add_ep(self, points):
        self.ep += points#*30000
        if self.ep > self.ep_max and self.level<25:           #LevelUP!
            tmp_circle = self.circle
            self.ep = self.ep - self.ep_max
            self.ep_max += 50
            self.level += 1

            for v in xrange(4):
                self.siav[v] += self.siav_bonus[v]
                self.cur_siav[v] += self.siav_bonus[v]

            self.attr[2:] = formulas.calc_attr(self.siav)
            self.cur_attr[:2] = self.attr[:2]

            dc_sfx["lvlup"].play()
            if self.ep > self.ep_max:
                self.add_ep(0)

            if self.level >= (self.circle)*self.circlemult:
                if self.circle < len(circle):
                    self.spells.extend(circle[self.circle]["spells"])
                    self.circle += 1
                    self.gen_spellbook()
                    if self.ep > self.ep_max:
                        self.add_ep(0)
            return self.circle > tmp_circle
        elif self.ep < 0:
            self.ep = 0
        return False

    def change_siav(self, values):
        for v in xrange(len(values)):
            self.siav[v] += values[v]
            self.cur_siav[v] += values[v]
        self.attr = formulas.calc_attr(self.siav)
        self.cur_attr = formulas.calc_attr(self.cur_siav)


    def change_attr(self, values):
        if len(values) > len(self.cur_attr):
            self.add_ep(values.pop[-1])

        for v in xrange(len(values)):
            self.cur_attr[v] += values[v]
            if self.cur_attr[v] > self.attr[v] and v<2:
                self.cur_attr[v] = self.attr[v]
            elif self.cur_attr[v] < 0:
                self.cur_attr[v] = 0

        if self.cur_attr[0] <= 0:
            self.cur_attr[0], self.cur_attr[1] = 0,0
            self.cond =  [1,0,0,0,0,0,0,0]
            self.death_anim()
            return False  #woops, died!
        return True  #all ok

    def print_data(self):
        print "-----------------"
        print "Name: ", self.name
        print "SIAV: ", self.cur_siav, self.siav
        print "Cond: ", self.cond
        print "Attr: ", self.cur_attr
        print "lvep: ", self.level, self.ep
        print "-----------------"



    def apply_effects(self):
        mp_mod, hp_mod = 1, 1

        if self.cond[2]:  #poisoned -> reduce hp
            self.cur_attr[0] -= self.cond[2]*5

        if self.attr[0]:
            hp_mod = 1.0*self.cur_attr[0] / self.attr[0]
        if self.attr[1]:
            mp_mod = 1.0*self.cur_attr[1] / self.attr[1]

        #siav-effects
        self.cur_siav = self.siav[:]  #restore cur_siav
        for i in xrange(4):
            self.cur_siav[i] += self.effect_sum[0][i]

        self.cond = self.effect_sum[1][:]

        #cond effects
        if self.cond[1] or self.cond[3]:  #blind or asleep -> AGI=0
            self.cur_siav[2] -= self.cur_siav[2]



        if self.cond[5]:  #weak -> half all attributes
            for i in xrange(4):
                self.cur_siav[i] *= 0.5
            self.cur_attr[0] *= 0.5  #half cur hp
            self.cur_attr[1] *= 0.5  #half cur mana

        if self.cond[6]:  #dazed -> half AGI
            self.cur_siav[2] = self.cur_siav[2] * 0.5

        attr = formulas.calc_attr(self.cur_siav)
        self.cur_attr[2:] = attr[2:]
        self.attr[0] = int(attr[0])
        self.attr[1] = int(attr[1])

        self.cur_attr[0] = int(self.attr[0]*hp_mod)
        self.cur_attr[1] = int(self.attr[1]*mp_mod)


    def add_effect(self, siav=None, cond=None):
        if siav:
            for i in xrange(len(siav)):
                self.effect_sum[0][i] += siav[i]

        if cond:
            for i in xrange(len(cond)):
                if cond[i] >= 0:
                    self.effect_sum[1][i] += cond[i]  #add conditon
                else:
                    self.effect_sum[1][i] = 0  #remove condition -> 0


    def cast(self, name):
        if spell.has_key(name):
            mana = self.cur_attr[1] - spell[name]["mana"]
            if mana >= 0:
                self.cur_attr[1] = mana
                return True
            return False


    def change_cur_siav(self, values):
        for i in xrange(len(values)):
            self.cur_siav[i] += values[i]
            if self.cur_siav[i] < 0:
                self.cur_siav[i] = 0


    def apply_spell(self, name):
        if spell.has_key(name):
            self.apply_item(spell[name])

    def apply_item(self, i):
        if not self.cond[0]:
            if i.has_key("dur"):
                self.effects.append(i.copy())
            if i.has_key("atteff"):
                self.change_attr(i["atteff"])
            if i.has_key("siaveff"):
                self.add_effect(siav=i["siaveff"])
            if i.has_key("coneff"):
                self.add_effect(cond=i["coneff"])
            self.apply_effects()
            self.print_data()
            return
        elif i.has_key("coneff") and self.cond[0]: #revive!
            if i["coneff"][0] < 0:
                self.cond[0] = 0
                if i.has_key("atteff"):
                    self.change_attr(i["atteff"])
                self.res_anim()
                self.died = False
        self.apply_effects()


    def unapply_item(self, i):
        if i.has_key("siaveff"):
            for j in xrange(len(i["siaveff"])):
                self.effect_sum[0][j] -= i["siaveff"][j]

        if i.has_key("coneff"):
            for j in xrange(len(i["coneff"])):
                self.effect_sum[1][j] -= i["coneff"][j]

        for x in xrange(len(self.effect_sum[1])):
            if self.effect_sum[1][x] < 0:
                self.effect_sum[1][x] = 0

        self.print_data()

    def tick(self):
        tmp_effects = self.effects[:]  #make copy(!) of self.effects
        for eff in tmp_effects:
            eff["dur"] -= 1
            if eff["dur"] <= 0:
                self.unapply_item(eff)
                self.effects.remove(eff)

        self.apply_effects()
        if self.cur_attr[0]<=0: #dead
            self.die()
            return

    def get_actionlist(self):
        ## returns list of available actions
        if self.cond[0] or self.cond[1] or self.cond[6] or self.cond[7]:
            return None
        if self.spells and not self.cond[4]:
            return ["Attack", "Spell", "Run", "Item"]
        return ["Attack", "Run", "Item"]

    def die(self):
        self.cur_attr[0], self.cur_attr[1] = 0,0
        self.cond =  [1,0,0,0,0,0,0,0,0]
        self.action=None
        for eff in self.effects:
            self.unapply_item(eff)
        self.effects = []
        if not self.died:
            self.death_anim()
            self.died = True


    def res_anim(self):
        pass

    def death_anim(self):
        pass

    def set_position(self, pos, surf):
        size = self.image.get_size()
        self.bg = pygame.Surface(size)
        if self.name=="Mercator" or self.name=="Brugoth" or \
           self.name=="Xekolth" or self.name=="Felimon" or \
           self.name=="Lord Zjokrax" or self.name=="Castle Guard":
            self.pos = (pos[0]-size[0]/2, pos[1]-size[1]/2)
        else:
            self.pos = pos
        self.bg.blit(surf, (0,0), pygame.Rect(self.pos, size))
        self.surf = surf
        self.surf.blit(self.image, self.pos)


class Monster(FightEntity):
    def __init__(self, name):
        FightEntity.__init__(self)
        self.name = name
        self.monster = 1
        self.siav = monster[name]["siav"][:]
        self.cur_siav = monster[name]["siav"][:]
        self.attr = formulas.calc_attr(self.siav)
        self.cur_attr = formulas.calc_attr(self.siav)


        if monster[name].has_key("lvl"):
            self.level = monster[name]["lvl"]

        if not monster[name].has_key("img"):
            self.image = unknown_monster.copy()
        else:
            self.image = monster[name]["img"]

        if monster[name].has_key("circle"):
            self.circles = monster[name]["circle"]

        for nr in self.circles:
            self.spells.extend(circle[nr]["spells"])

    def death_anim(self):
        self.surf.blit(self.bg, self.pos)
        dc_sfx["mdeath"].play()
